/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.grid;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.qcc.EsearchJsonRecord;
import com.ruoyi.system.domain.qcc.EsearchLog;
import com.ruoyi.system.domain.qcc.EsearchRecord;
import com.ruoyi.system.domain.qcc.enums.EsearchTypeEnum;
import com.ruoyi.system.domain.qcc.enums.EsearchWayEnum;
import com.ruoyi.system.domain.qcc.ext.EsearchRecordExt;
import com.ruoyi.system.domain.qcc.ext.EsearchResult;
import com.ruoyi.system.domain.qcc.factory.EsearchFactory;
import com.ruoyi.system.domain.qcc.util.FinalCostHttpHelper;
import com.ruoyi.system.service.grid.qcc.impl.EsearchJsonRecordService;
import com.ruoyi.system.service.grid.qcc.impl.EsearchLogService;
import com.ruoyi.system.service.grid.qcc.impl.EsearchRecordService;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u4e1a\u7ba1\u7406-\u4e00\u4f01\u4e00\u6863"})
@RestController
@RequestMapping(value={"/api/grid/company/qcc"})
public class CompanyQccController {
    @Autowired
    private EsearchJsonRecordService esearchJsonRecordService;
    @Autowired
    private EsearchFactory searchFactory;
    @Autowired
    private EsearchLogService logService;
    @Autowired
    private EsearchRecordService recordService;
    @Value(value="${app.qcc.appKey}")
    private String appKey;
    @Value(value="${app.qcc.secKey}")
    private String secKey;
    @Value(value="${app.qcc.searchName}")
    private String searchName;
    @Value(value="${app.qcc.searchInfo}")
    private String searchInfo;
    @Value(value="${app.qcc.searchCode}")
    private String searchCode;

    @GetMapping(value={"getQccCompanyInfo"})
    public AjaxResult getQccCompanyInfo(@RequestParam(value="keyword") String keyword) {
        if (StringUtils.isBlank((CharSequence)keyword)) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        EsearchJsonRecord existRecord = (EsearchJsonRecord)this.esearchJsonRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(EsearchJsonRecord::getCreditCode, (Object)keyword));
        if (existRecord != null) {
            EsearchRecordExt esearchRecordExt = new EsearchRecordExt();
            BeanUtils.copyProperties((Object)existRecord, (Object)esearchRecordExt);
            this.setOriginalNameStr(esearchRecordExt);
            return AjaxResult.success((Object)esearchRecordExt);
        }
        String paramStr = "keyword=" + keyword;
        String reqUri = this.searchInfo.concat("?key=").concat(this.appKey).concat("&").concat(paramStr);
        EsearchResult qccResult = this.searchFactory.getHandler(EsearchTypeEnum.qcc).searchByUrl(reqUri, this.appKey, this.secKey);
        String status = qccResult.getStatus();
        EsearchJsonRecord qccRecord = qccResult.getRecord();
        if (FinalCostHttpHelper.isNormalRequest((String)status)) {
            this.saveLog(reqUri);
        }
        if (FinalCostHttpHelper.isSuccessResult((String)status) && qccRecord != null) {
            this.saveInfo(qccRecord, keyword, EsearchWayEnum.precise, reqUri);
            EsearchRecordExt esearchRecordExt = new EsearchRecordExt();
            BeanUtils.copyProperties((Object)qccRecord, (Object)esearchRecordExt);
            this.setOriginalNameStr(esearchRecordExt);
            return AjaxResult.success((Object)esearchRecordExt);
        }
        return AjaxResult.error((String)"\u67e5\u8be2\u5931\u8d25, \u65e0\u6b64\u4f01\u4e1a");
    }

    private void setOriginalNameStr(EsearchRecordExt record) {
        if (StringUtils.isNotBlank((CharSequence)record.getOriginalName()) && record.getOriginalName().contains("Name")) {
            JSONArray jsonArray = JSONArray.parseArray((String)record.getOriginalName());
            ArrayList<String> nameList = new ArrayList<String>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = (JSONObject)jsonArray.get(i);
                String name = jsonObject.getString("Name");
                if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                nameList.add(name);
            }
            if (!CollectionUtils.isEmpty(nameList)) {
                record.setOriginalNameStr(StringUtils.join(nameList, (String)","));
            }
        }
    }

    private void saveLog(String url) {
        EsearchLog log = new EsearchLog();
        log.setCtime(Long.valueOf(System.currentTimeMillis()));
        log.setUrl(url);
        this.logService.save((Object)log);
    }

    private void saveInfo(EsearchJsonRecord result, String keyWord, EsearchWayEnum way, String url) {
        EsearchRecord bean = new EsearchRecord();
        bean.setId(UUID.randomUUID().toString());
        bean.setUrl(url);
        bean.setKeyWord(keyWord);
        bean.setWay(way.getMode());
        bean.setCtime(Long.valueOf(System.currentTimeMillis()));
        bean.setTokenJson(JSON.toJSONString((Object)result));
        this.recordService.save((Object)bean);
        if (ObjectUtil.isNotEmpty((Object)result)) {
            this.esearchJsonRecordService.save((Object)result);
        }
    }
}

