/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridCompanyLand;
import com.ruoyi.system.domain.grid.GridCompanyLandExample;
import com.ruoyi.system.service.grid.GridCompanyLandService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7f51\u683c\u7ba1\u7406 - \u7ecf\u6d4e\u5730\u5757\u4e0e\u4f01\u4e1a\u5173\u8054"})
@RestController
@RequestMapping(value={"/api/grid/company/land"})
public class CompanyLandController {
    @Autowired
    private GridCompanyLandService gridCompanyLandService;

    @GetMapping(value={"/page"})
    public AjaxResult page(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="companyId", required=false) String companyId, @RequestParam(name="landId", required=false) String landId, @RequestParam(name="landPurpose", required=false) String landPurpose) {
        return AjaxResult.success((Object)this.gridCompanyLandService.page(pageNo, pageSize, companyId, landId, landPurpose));
    }

    @PostMapping(value={"/saveOrUpdate"})
    public AjaxResult saveOrUpdate(@RequestBody GridCompanyLand wsCompanyLand) {
        return this.gridCompanyLandService.saveOrUpdate(wsCompanyLand);
    }

    @GetMapping(value={"/detail"})
    public AjaxResult detail(@RequestParam(value="id") String id) {
        return AjaxResult.success((Object)this.gridCompanyLandService.detail(id));
    }

    @GetMapping(value={"/delete"})
    public AjaxResult delete(@RequestParam(value="id") String id) {
        this.gridCompanyLandService.delete(id);
        return AjaxResult.success((String)"success");
    }

    @GetMapping(value={"bigScreen/info/statistic"})
    public AjaxResult infoStatistic(@RequestParam(value="year", required=false) String year) {
        return AjaxResult.success((Object)this.gridCompanyLandService.infoStatistic(year));
    }

    @GetMapping(value={"bigScreen/lease/statistic"})
    public AjaxResult leaseStatistic() {
        return AjaxResult.success((Object)this.gridCompanyLandService.leaseStatistic());
    }

    @GetMapping(value={"bigScreen/permuSort/list"})
    public AjaxResult permuSortList(@RequestParam(value="year", required=false) String year) {
        return AjaxResult.success((Object)this.gridCompanyLandService.permuSortList(year));
    }

    @GetMapping(value={"/companyCount"})
    public AjaxResult companyCount(@RequestParam(value="landId") String landId) {
        GridCompanyLandExample example = new GridCompanyLandExample();
        GridCompanyLandExample.Criteria criteria = example.createCriteria();
        criteria.andLandIdEqualTo(landId);
        criteria.andIsValidEqualTo("1");
        return AjaxResult.success((Object)this.gridCompanyLandService.countByExample((Object)example));
    }
}

