/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.ext.GridCompanyEconomyInfoExt;
import com.ruoyi.system.service.grid.GridCompanyEconomyInfoService;
import io.swagger.annotations.Api;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6570\u636e\u770b\u677f - \u4f01\u4e1a\u7ecf\u6d4e\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/api/grid/company/economyIfo"})
public class CompanyEconomyInfoController {
    @Autowired
    private GridCompanyEconomyInfoService companyEconomyInfoService;

    @PostMapping(value={"import"}, headers={"content-type=multipart/form-data"})
    public AjaxResult importExcel(@RequestParam(value="file") MultipartFile file) {
        return this.companyEconomyInfoService.importExcel(file);
    }

    @GetMapping(value={"/list"})
    public AjaxResult list(@RequestParam(name="companyId") String companyId) {
        HashMap<String, List> result = new HashMap<String, List>();
        List infos = this.companyEconomyInfoService.listEconomyInfos(companyId, null);
        result.put("list", infos);
        return AjaxResult.success(result);
    }

    @GetMapping(value={"/page"})
    public AjaxResult page(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="companyKeyword", required=false) String companyKeyword, @RequestParam(value="qylxCode", required=false) String qylxCode, @RequestParam(value="year", required=false) String year, @RequestParam(value="orderType", defaultValue="desc") String orderType, @RequestParam(value="orderValue", defaultValue="year") String orderValue) {
        return AjaxResult.success((Object)this.companyEconomyInfoService.pageEconomyInfos(pageNo, pageSize, year, qylxCode, companyKeyword, orderValue, orderType));
    }

    @GetMapping(value={"/check"})
    public AjaxResult check(@RequestParam(value="year") String year, @RequestParam(name="companyId") String companyId) {
        if (StringUtils.isBlank((CharSequence)year) || StringUtils.isBlank((CharSequence)companyId)) {
            return AjaxResult.error((int)400, (String)"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        return AjaxResult.success((Object)this.companyEconomyInfoService.checkIsExist(year, companyId));
    }

    @PostMapping(value={"/save"})
    public AjaxResult save(@RequestBody GridCompanyEconomyInfoExt infoExt) {
        infoExt.setYearSales(infoExt.getSales().toString());
        infoExt.setYearTaxes(infoExt.getTaxes().toString());
        int sale = 0;
        for (String s : infoExt.getSales()) {
            sale += Integer.parseInt(s);
        }
        infoExt.setSale(BigDecimal.valueOf(sale));
        int tax = 0;
        for (String s : infoExt.getTaxes()) {
            tax += Integer.parseInt(s);
        }
        infoExt.setTax(BigDecimal.valueOf(tax));
        this.companyEconomyInfoService.save(infoExt);
        return AjaxResult.success((String)"\u63d0\u4ea4\u6210\u529f");
    }

    @GetMapping(value={"/detail/{id}"})
    public AjaxResult detail(@PathVariable(value="id") String id) {
        return AjaxResult.success((Object)this.companyEconomyInfoService.detail(id));
    }

    @GetMapping(value={"/delete/{id}"})
    public AjaxResult delete(@PathVariable(value="id") String id) {
        this.companyEconomyInfoService.delete(id);
        return AjaxResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/perMu/count"})
    public AjaxResult perMuCount(@RequestParam(value="year") String year) {
        if (StringUtils.isBlank((CharSequence)year)) {
            return AjaxResult.error((int)400, (String)"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        return AjaxResult.success((Object)this.companyEconomyInfoService.perMuCount(year));
    }

    @GetMapping(value={"/sale/count"})
    public AjaxResult saleCount(@RequestParam(value="year") String year) {
        if (StringUtils.isBlank((CharSequence)year)) {
            return AjaxResult.error((int)400, (String)"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        return AjaxResult.success((Object)this.companyEconomyInfoService.saleCount(year));
    }

    @GetMapping(value={"/tax/count"})
    public AjaxResult taxCount(@RequestParam(value="year") String year) {
        if (StringUtils.isBlank((CharSequence)year)) {
            return AjaxResult.error((int)400, (String)"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        return AjaxResult.success((Object)this.companyEconomyInfoService.taxCount(year));
    }

    @GetMapping(value={"/group/info"})
    public AjaxResult groupInfo(@RequestParam(value="landId") String landId, @RequestParam(value="year") String year) {
        if (StringUtils.isBlank((CharSequence)year) || StringUtils.isBlank((CharSequence)landId)) {
            return AjaxResult.error((int)400, (String)"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        return AjaxResult.success((Object)this.companyEconomyInfoService.loadCompanyLandInfo(landId, year));
    }
}

