/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.service.grid.GridCompanyEconomyService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6570\u636e\u770b\u677f - \u4f01\u4e1a\u7ecf\u6d4e\u7edf\u8ba1"})
@RestController
@RequestMapping(value={"/api/grid/company/economy"})
public class CompanyEconomyController {
    @Autowired
    private GridCompanyEconomyService gridCompanyEconomyService;

    @PostMapping(value={"import"}, headers={"content-type=multipart/form-data"})
    public AjaxResult importExcel(@RequestParam(value="file") MultipartFile file, @RequestParam(value="belongTime") String belongTime) {
        return this.gridCompanyEconomyService.importExcel(file, belongTime);
    }

    @GetMapping(value={"/getNowYearCount"})
    public AjaxResult getNowYearCount(String wgCode) {
        return AjaxResult.success((Object)this.gridCompanyEconomyService.getNowYearCount(wgCode));
    }

    @GetMapping(value={"/getMonthCount"})
    public AjaxResult getMonthCount(@RequestParam(value="year") Integer year) {
        return AjaxResult.success((Object)this.gridCompanyEconomyService.getMonthCount(year));
    }

    @GetMapping(value={"/getTopTenCount"})
    public AjaxResult getTopTenCount(String wgCode, String type) {
        return AjaxResult.success((Object)this.gridCompanyEconomyService.getTopTenCount(wgCode, type));
    }
}

