/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.grid;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.bean.BeanCopyUtil;
import com.ruoyi.common.zqt.ZQTPageUtil;
import com.ruoyi.system.domain.grid.CompanyLabel;
import com.ruoyi.system.domain.grid.CompanyLabelLevelOne;
import com.ruoyi.system.domain.grid.GridCompany;
import com.ruoyi.system.domain.grid.GridCompanyPeople;
import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.grid.enums.GridCompanyLevelEnum;
import com.ruoyi.system.domain.grid.ext.GridCompanyPeopleExt;
import com.ruoyi.system.domain.grid.vo.GridCompanySearchParam;
import com.ruoyi.system.domain.other.BsCommon;
import com.ruoyi.system.mapper.grid.GridCompanyMapper;
import com.ruoyi.system.service.grid.GridCompanyPeopleService;
import com.ruoyi.system.service.grid.GridCompanyService;
import com.ruoyi.system.service.grid.GridRegionService;
import com.ruoyi.system.service.other.BsCommonService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7f51\u683c\u7ba1\u7406 - \u4f01\u4e1a\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/grid/company"})
public class CompanyController
extends BaseController {
    @Autowired
    private GridCompanyService gridCompanyService;
    @Autowired
    private GridCompanyPeopleService gridCompanyPeopleService;
    @Autowired
    private BsCommonService bsCommonService;
    @Autowired
    private GridRegionService gridRegionService;
    @Autowired
    private GridCompanyMapper gridCompanyMapper;

    @RequestMapping(value={"/page"}, method={RequestMethod.GET})
    public AjaxResult page(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="wgCode", required=false) String wgCode, @RequestParam(value="qylxCode", required=false) String qylxCode, @RequestParam(value="creditCode", required=false) String creditCode, @RequestParam(value="value", required=false) String value, @RequestParam(value="isClosed", required=false) Byte isClosed, @RequestParam(value="isUnowned", required=false) Byte isUnowned) {
        try {
            GridCompany wsCompany = new GridCompany();
            wsCompany.setWgCode(wgCode);
            wsCompany.setQylxCode(qylxCode);
            wsCompany.setCreditCode(creditCode);
            wsCompany.setIsClosed(isClosed);
            wsCompany.setIsUnowned(isUnowned);
            PageHelper.startPage((int)pageNum, (int)pageSize);
            PageInfo pageInfo = this.gridCompanyService.page(wsCompany, value);
            return AjaxResult.success((Object)pageInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
    }

    @PostMapping(value={"/add"})
    public AjaxResult add(@RequestBody GridCompany wsCompany) {
        wsCompany.setCreateId(this.getUserId());
        return this.gridCompanyService.add(wsCompany);
    }

    @PostMapping(value={"/edit"})
    public AjaxResult edit(@RequestBody GridCompany wsCompany) {
        wsCompany.setUpdateId(this.getUserId());
        return this.gridCompanyService.edit(wsCompany);
    }

    @GetMapping(value={"/detail/{id}"})
    public AjaxResult detail(@PathVariable(value="id") String id) {
        return this.gridCompanyService.detail(id);
    }

    @GetMapping(value={"/delete"})
    public AjaxResult delete(@RequestParam(value="id") String id) {
        return this.gridCompanyService.delete(id);
    }

    @GetMapping(value={"/detail"})
    public AjaxResult detailByCreditCode(@RequestParam(value="creditCode") String creditCode) {
        return this.gridCompanyService.detailByCreditCode(creditCode);
    }

    @GetMapping(value={"/otherCompanyPage"})
    public AjaxResult otherCompany(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="creditCode") String creditCode, @RequestParam(value="wgCode") String wgCode) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo pageInfo = new PageInfo(this.gridCompanyService.otherCompany(creditCode, wgCode));
        return AjaxResult.success((Object)pageInfo);
    }

    @GetMapping(value={"/economyPage"})
    public AjaxResult economy(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="creditCode") String creditCode, @RequestParam(value="belongTime", required=false) String belongTime) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo pageInfo = new PageInfo(this.gridCompanyService.economy(creditCode, belongTime));
        return AjaxResult.success((Object)pageInfo);
    }

    @GetMapping(value={"/companyToPeoplePage"})
    public AjaxResult companyToPeoplePage(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="companyId", required=false) String companyId, @RequestParam(value="creditCode", required=false) String creditCode) {
        try {
            PageHelper.startPage((int)pageNum, (int)pageSize);
            List companyPeopleList = this.gridCompanyPeopleService.selectGridCompanyPeopleByCompanyId(companyId, creditCode, null);
            List companyPeopleExtList = BeanCopyUtil.bathToBean((Collection)companyPeopleList, GridCompanyPeopleExt.class);
            Map<String, String> regionMap = this.gridRegionService.getGridRegionMap().stream().collect(Collectors.toMap(GridRegion::getWgCode, GridRegion::getWgName));
            Map<String, String> commonMap = this.bsCommonService.getBsCommonMap().stream().collect(Collectors.toMap(BsCommon::getCode, BsCommon::getName));
            for (GridCompanyPeopleExt c : companyPeopleExtList) {
                this.gridCompanyPeopleService.selectGridCompanyPeopleExt(regionMap, commonMap, c, Boolean.valueOf(false), Boolean.valueOf(true));
            }
            PageInfo pageInfo = ZQTPageUtil.build((List)companyPeopleList, (List)companyPeopleExtList);
            return AjaxResult.success((Object)pageInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
    }

    @PostMapping(value={"/companyBindPeople"})
    public AjaxResult companyBindPeople(@RequestBody GridCompanyPeople wsCompanyPeople) {
        return this.gridCompanyService.companyBindPeople(wsCompanyPeople);
    }

    @GetMapping(value={"/companyUnbindPeople"})
    public AjaxResult companyUnbindPeople(@RequestParam(value="id") String id) {
        this.gridCompanyPeopleService.deleteByStringPrimaryKey(id);
        return AjaxResult.success(null);
    }

    @PostMapping(value={"import"}, headers={"content-type=multipart/form-data"})
    public AjaxResult importExcel(@RequestParam(value="file") MultipartFile file, @RequestParam(value="createId") String createId) {
        return this.gridCompanyService.importExcel(file, createId);
    }

    @ApiOperation(value="\u4f01\u4e1a\u7b49\u7ea7\u679a\u4e3e")
    @GetMapping(value={"/level/enum"})
    public AjaxResult companyLevel() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(GridCompanyLevelEnum.RED.getCode(), GridCompanyLevelEnum.RED.getValue());
        map.put(GridCompanyLevelEnum.YELLOW.getCode(), GridCompanyLevelEnum.YELLOW.getValue());
        map.put(GridCompanyLevelEnum.GREEN.getCode(), GridCompanyLevelEnum.GREEN.getValue());
        return AjaxResult.success(map);
    }

    @ApiOperation(value="\u6240\u6709\u4f01\u4e1a\u5217\u8868")
    @GetMapping(value={"/allCompanyList"})
    public AjaxResult getCompanyList(@RequestParam(value="wgCode") String wgCode) {
        GridCompanySearchParam param = new GridCompanySearchParam();
        if (StringUtils.isNotBlank((CharSequence)wgCode)) {
            param.setWgCodeLikes(Arrays.asList(wgCode.split(",")));
        }
        return AjaxResult.success((Object)this.gridCompanyService.getAllCompanyList(param));
    }

    @PostMapping(value={"/saveCompanyLabel"})
    public AjaxResult saveCompanyLabel(@RequestBody CompanyLabel companyLabel) {
        String id = companyLabel.getId();
        List labels = companyLabel.getLabels();
        String strLabel = "";
        for (CompanyLabelLevelOne label : labels) {
            strLabel = strLabel + label.getLevelTwo() + ":" + label.getValue() + ",";
        }
        return AjaxResult.success((Object)this.gridCompanyMapper.insertLabelById(id, strLabel));
    }

    @GetMapping(value={"/selectCompanyLabel"})
    public AjaxResult selectCompanyLabel(@RequestParam(value="id") String id) {
        String label = this.gridCompanyMapper.selectLabelById(id);
        ArrayList<CompanyLabelLevelOne> res = new ArrayList<CompanyLabelLevelOne>();
        List<String> labels = Arrays.asList(label.split(","));
        for (String labelTwo : labels) {
            List<String> labelTwos = Arrays.asList(labelTwo.split(":"));
            CompanyLabelLevelOne companyLabel = new CompanyLabelLevelOne();
            companyLabel.setLevelTwo(labelTwos.get(0));
            companyLabel.setValue(labelTwos.get(1));
            res.add(companyLabel);
        }
        return AjaxResult.success(res);
    }
}

