/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.form;

import com.ruoyi.common.annotation.Anonymous;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.form.MdFormRecord;
import com.ruoyi.system.domain.form.params.FormRecordQuery;
import com.ruoyi.system.service.form.FormRecordManager;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5728\u7ebf\u8868\u5355 - \u8868\u5355\u6570\u636e"})
@RestController
@RequestMapping(value={"/api/form/record"})
public class FormRecordController
extends BaseController {
    @Autowired
    private FormRecordManager recordManager;

    @PostMapping(value={"/mind"})
    @ResponseBody
    public AjaxResult mind(@RequestParam(name="form_id") String form_id, @RequestParam(name="noRecord", defaultValue="0") Integer noRecord) {
        if (StringUtils.isBlank((CharSequence)form_id)) {
            return AjaxResult.build((int)400, (String)"\u53c2\u6570\u5f02\u5e38", (String)"form_id\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.recordManager.mind(form_id, noRecord, Boolean.valueOf(false));
            return AjaxResult.success((String)"\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage());
        }
    }

    @RequestMapping(value={"/labels"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxResult queryLabels(@RequestParam(name="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return AjaxResult.build((int)400, (String)"\u53c2\u6570\u5f02\u5e38", (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return AjaxResult.success((Object)this.recordManager.formLabels(id));
    }

    @GetMapping(value={"/list"})
    @ResponseBody
    public AjaxResult list(FormRecordQuery query) {
        if (query == null) {
            return AjaxResult.build((int)400, (String)"\u53c2\u6570\u5f02\u5e38", (String)"query\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        query.setUserId(this.getUserId());
        try {
            return AjaxResult.success((Object)this.recordManager.list(query));
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage());
        }
    }

    @GetMapping(value={"/commit/list"})
    @ResponseBody
    public AjaxResult commit_list(FormRecordQuery query) {
        if (query == null || StringUtils.isBlank((CharSequence)query.getForm_id())) {
            return AjaxResult.build((int)400, (String)"\u53c2\u6570\u5f02\u5e38", (String)"query\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            query.setCommit_status(Integer.valueOf(1));
            return AjaxResult.success((Object)this.recordManager.queryCommit(query));
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage());
        }
    }

    @GetMapping(value={"/no/list"})
    @ResponseBody
    public AjaxResult no_list(FormRecordQuery query) {
        if (query == null || StringUtils.isBlank((CharSequence)query.getForm_id())) {
            return AjaxResult.build((int)400, (String)"\u53c2\u6570\u5f02\u5e38", (String)"query\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            query.setCommit_status(Integer.valueOf(0));
            return AjaxResult.success((Object)this.recordManager.queryNoCommit(query));
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage());
        }
    }

    @Anonymous
    @GetMapping(value={"/export"})
    public void export(FormRecordQuery query, HttpServletResponse response) throws IOException {
        if (query == null || StringUtils.isBlank((CharSequence)query.getForm_id())) {
            throw new RuntimeException("\u53c2\u6570\u5f02\u5e38");
        }
        query.setCommit_status(Integer.valueOf(1));
        this.recordManager.export(response, query);
    }

    @GetMapping(value={"/no/export"})
    public void no_export(FormRecordQuery query, HttpServletResponse response) throws IOException {
        if (query == null || StringUtils.isBlank((CharSequence)query.getForm_id())) {
            throw new RuntimeException("\u53c2\u6570\u5f02\u5e38");
        }
        query.setCommit_status(Integer.valueOf(0));
        this.recordManager.no_export(response, query);
    }

    @PostMapping(value={"/save"})
    @ResponseBody
    public AjaxResult save(@RequestBody MdFormRecord body) {
        try {
            return AjaxResult.success((String)"\u64cd\u4f5c\u6210\u529f", (Object)this.recordManager.save(body));
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage());
        }
    }

    @GetMapping(value={"/detail"})
    @ResponseBody
    public AjaxResult detail(@RequestParam(name="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return AjaxResult.build((int)400, (String)"\u53c2\u6570\u5f02\u5e38", (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            return AjaxResult.success((Object)this.recordManager.detail(id));
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage());
        }
    }

    @PostMapping(value={"/delete"})
    public AjaxResult delete(@RequestBody List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return AjaxResult.build((int)400, (String)"\u53c2\u6570\u5f02\u5e38", (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return AjaxResult.success((Object)this.recordManager.deleteRecord(ids));
    }

    @GetMapping(value={"/import/template"})
    public void import_template(@RequestParam(name="formId", required=true) String formId, HttpServletResponse res) throws IOException {
        if (StringUtils.isBlank((CharSequence)formId)) {
            throw new RuntimeException("\u53c2\u6570\u5f02\u5e38");
        }
        this.recordManager.importTemplate(res, formId);
    }
}

