/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.form;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.form.MdForm;
import com.ruoyi.system.domain.form.enums.EnumFormStatus;
import com.ruoyi.system.domain.form.params.FormAddTemplateBody;
import com.ruoyi.system.domain.form.params.FormCopyBody;
import com.ruoyi.system.domain.form.params.FormQuery;
import com.ruoyi.system.service.form.FormManager;
import io.swagger.annotations.Api;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5728\u7ebf\u8868\u5355 - \u8868\u5355\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/form"})
public class FormController
extends BaseController {
    @Autowired
    private FormManager formManager;

    @GetMapping(value={"/list"})
    @ResponseBody
    public AjaxResult list(FormQuery query) {
        if (query == null) {
            return AjaxResult.build((int)400, (String)"\u53c2\u6570\u5f02\u5e38", (String)"query\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            query.setStatus(Integer.valueOf(EnumFormStatus.normal.code));
            return AjaxResult.success((Object)this.formManager.query(query));
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage());
        }
    }

    @GetMapping(value={"/detail"})
    @ResponseBody
    public AjaxResult detail(@RequestParam(name="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return AjaxResult.build((int)400, (String)"\u53c2\u6570\u5f02\u5e38", (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            return AjaxResult.success((Object)this.formManager.detail2(id));
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage());
        }
    }

    @PostMapping(value={"/save"})
    @ResponseBody
    public AjaxResult save(@RequestBody MdForm body) {
        try {
            return AjaxResult.success((String)this.formManager.save(body));
        }
        catch (RuntimeException e1) {
            return AjaxResult.build((int)600, (String)e1.getMessage(), (String)e1.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage());
        }
    }

    @PostMapping(value={"/deleteById"})
    @ResponseBody
    public AjaxResult deleteById(@RequestBody MdForm body) {
        try {
            int count = this.formManager.deleteById(body);
            if (count > 0) {
                return AjaxResult.success((String)"\u5220\u9664\u6210\u529f");
            }
            return AjaxResult.build((int)500, (String)"\u5220\u9664\u5931\u8d25", (String)"\u5220\u9664\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage());
        }
    }

    @PostMapping(value={"/publish"})
    @ResponseBody
    public AjaxResult publish(@RequestBody FormAddTemplateBody body) {
        try {
            this.formManager.publish(body);
            return AjaxResult.build((int)200, (String)"\u53d1\u5e03\u6210\u529f", (String)"\u53d1\u5e03\u6210\u529f");
        }
        catch (RuntimeException e1) {
            return AjaxResult.build((int)600, (String)e1.getMessage(), (String)e1.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage());
        }
    }

    @GetMapping(value={"/readAuth"})
    @ResponseBody
    public AjaxResult readAuth(@RequestParam(name="userId") String userId, @RequestParam(name="formId") String formId) {
        if (StringUtils.isEmpty((CharSequence)userId) || StringUtils.isEmpty((CharSequence)formId)) {
            return AjaxResult.build((int)400, (String)"\u53c2\u6570\u5f02\u5e38", (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            return this.formManager.readAuth(userId, formId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage());
        }
    }

    @PostMapping(value={"/copy"})
    @ResponseBody
    public AjaxResult copy(@RequestBody FormCopyBody formCopyBody) {
        if (StringUtils.isEmpty((CharSequence)formCopyBody.getFormId()) || StringUtils.isEmpty((CharSequence)formCopyBody.getName())) {
            return AjaxResult.build((int)400, (String)"\u53c2\u6570\u5f02\u5e38", (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            int count = this.formManager.copyForm(formCopyBody);
            if (count > 0) {
                return AjaxResult.success((String)"\u590d\u5236\u6210\u529f");
            }
            return AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)"\u590d\u5236\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage());
        }
    }

    @PostMapping(value={"/stopById"})
    @ResponseBody
    public AjaxResult stopById(@RequestParam(name="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return AjaxResult.build((int)400, (String)"\u53c2\u6570\u5f02\u5e38", (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            return AjaxResult.success((Object)this.formManager.stopById(id));
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (String)e.getMessage());
        }
    }
}

