/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.common;

import com.easytec.oss.sdk.core.OssClient;
import com.easytec.oss.sdk.dto.EfsRequest;
import com.easytec.oss.sdk.dto.RequestResult;
import com.ruoyi.common.core.domain.AjaxResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u57fa\u7840\u670d\u52a1 - EFS\u6587\u4ef6\u4e0a\u4f20"})
@RestController
@RequestMapping(value={"/efs"})
public class EfsController {
    @Value(value="${app.zqt_id}")
    private String appId;

    @ApiOperation(value="\u56fe\u7247/\u89c6\u9891\u4e0a\u4f20")
    @PostMapping(value={"upload"}, headers={"content-type=multipart/form-data"})
    public AjaxResult upload(@ApiParam(name="file", value="\u4e0a\u4f20\u6587\u4ef6", required=true) MultipartFile file) {
        OssClient ossClient = new OssClient("https://api-efs.eazytec-cloud.com");
        String fileName = file.getOriginalFilename();
        String prefix = fileName.substring(fileName.lastIndexOf("."));
        try {
            File tempFile = File.createTempFile(UUID.randomUUID().toString(), prefix);
            file.transferTo(tempFile);
            EfsRequest efsRequest = new EfsRequest();
            efsRequest.setAppId(this.appId);
            efsRequest.setFileName(fileName);
            efsRequest.setLiveDay(Integer.valueOf(0));
            RequestResult result = ossClient.syncUpload(tempFile, efsRequest);
            return AjaxResult.success((Object)result.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error((String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
        }
    }
}

