package com.ruoyi.system.service.task.impl;

import com.ruoyi.system.domain.task.TkCommonReceive;
import com.ruoyi.system.domain.task.TkCommonReceiveExample;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.task.TkCommonReceiveMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.task.TkCommonReceiveService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
* @author Cesar
* @date  ${cTime}
* @desc TkCommonReceiveService实现
*/
@Service
@MyBaseService
public class TkCommonReceiveServiceImpl extends BaseServiceImpl<TkCommonReceiveMapper, TkCommonReceive, TkCommonReceiveExample> implements TkCommonReceiveService {

    private static final Logger LOGGER = LoggerFactory.getLogger(TkCommonReceiveServiceImpl.class);

    @Override
    public void deleteByTaskId(String taskId) {
        if (StringUtils.isBlank(taskId)){
            return;
        }
        TkCommonReceiveExample example = new TkCommonReceiveExample();
        example.createCriteria().andCommonTkIdEqualTo(taskId);
        this.deleteByExample(example);
    }
}