package com.ruoyi.system.domain.system.enums;

import com.ruoyi.system.domain.grid.enums.GridCompanyEcoInfoEnum;

/**
 * * Author: brenda
 * * 2024/6/17
 **/
public enum PermissionTypeEnum {

    ROLE("R","角色"),

    PERSONAL("P","人员"),

    DEPT("D","组织");

    private String code;

    private String value;

    private PermissionTypeEnum(String code, String value) {
        this.code = code;
        this.value = value;
    }

    public static PermissionTypeEnum getByCode(String code) {
        if (code == null || code.trim().length() <= 0) {
            return null;
        }
        for (int i = 0; i < values().length; i++) {
            if (values()[i].code.equals(code)) {
                return values()[i];
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }
}
