package com.ruoyi.system.service.visit.impl;

import cn.hutool.core.lang.Validator;
import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.grid.GridRegionExample;
import com.ruoyi.system.domain.visit.VisitFreePlan;
import com.ruoyi.system.domain.visit.VisitFreePlanExample;
import com.ruoyi.system.domain.visit.vo.VisitPlanSearchParam;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.grid.GridRegionMapper;
import com.ruoyi.system.mapper.visit.VisitFreePlanMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.visit.VisitFreePlanService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * VisitFreePlanService实现
 * Created by cesar.X on 2022/6/21.
 */
@Service
@MyBaseService
public class VisitFreePlanServiceImpl extends BaseServiceImpl<VisitFreePlanMapper, VisitFreePlan, VisitFreePlanExample> implements VisitFreePlanService {

    private static final Logger LOGGER = LoggerFactory.getLogger(VisitFreePlanServiceImpl.class);

    @Autowired
    VisitFreePlanMapper visitFreePlanMapper;

    @Autowired
    GridRegionMapper gridRegionMapper;

    @Override
    public Map<String, List<VisitFreePlan>> modelHasDone(String planModelId) {
        Validator.validateNotEmpty(planModelId, "自由走访计划Id为空");

        Map<String, List<VisitFreePlan>> result = new HashMap<>();
        result.put("done", new ArrayList<>());
        result.put("unDone", new ArrayList<>());

        VisitFreePlanExample freePlanExample = new VisitFreePlanExample();
        VisitFreePlanExample.Criteria criteria = freePlanExample.createCriteria();
        criteria.andPlanModelIdEqualTo(planModelId);
        criteria.andIsValidEqualTo("1");
        List<VisitFreePlan> freePlanList = visitFreePlanMapper.selectByExample(freePlanExample);

        if (!CollectionUtils.isEmpty(freePlanList)) {
            List<String> wgCodes = freePlanList.stream().map(VisitFreePlan::getWgCode).collect(Collectors.toList());

            GridRegionExample example1 = new GridRegionExample();
            GridRegionExample.Criteria criteria1 = example1.createCriteria();
            criteria1.andWgCodeIn(wgCodes);
            criteria1.andIsValidEqualTo("1");
            List<GridRegion> regionList = gridRegionMapper.selectByExample(example1);

            Map<String,String> regionMap = regionList.stream().collect(Collectors.toMap(GridRegion::getWgCode,GridRegion::getWgName));

            for(VisitFreePlan freePlan : freePlanList){
                if(regionMap.containsKey(freePlan.getWgCode())){
                    freePlan.setWgName(regionMap.get(freePlan.getWgCode()));
                }
            }

            result.put("done", freePlanList.stream().filter(o -> "4".equals(o.getHasDone())).collect(Collectors.toList()));
            result.put("unDone", freePlanList.stream().filter(o -> !"4".equals(o.getHasDone())).collect(Collectors.toList()));
        }

        return result;
    }

    @Override
    public List<VisitFreePlan> listByParams(VisitPlanSearchParam param) {
        return visitFreePlanMapper.listByParams(param);
    }

}