package com.ruoyi.system.service.publicservice.impl;

import com.google.common.collect.Lists;
import com.ruoyi.common.constant.BsConstants;
import com.ruoyi.common.core.redis.PublicServiceRedisCache;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.BsUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.sql.Query;
import com.ruoyi.system.domain.publicservice.TOtherappAttachment;
import com.ruoyi.system.domain.publicservice.TPublicServiceIfind;
import com.ruoyi.system.domain.system.enums.AttachEnums;
import com.ruoyi.system.mapper.publicservice.TOtherappAttachmentMapper;
import com.ruoyi.system.mapper.publicservice.TPublicServiceIfindMapper;
import com.ruoyi.system.service.publicservice.TOtherappAttachmentService;
import com.ruoyi.system.service.publicservice.TPublicServiceIfindService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 公共服务 我发现表
 * @author wujm<wujm@eazytec.com>
 */
@Service
public class TPublicServiceIfindServiceImpl implements TPublicServiceIfindService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Resource
	private TPublicServiceIfindMapper TPublicServiceIfindMapper;

	@Autowired
	private PublicServiceRedisCache redisCache;

	@Autowired
	private TOtherappAttachmentService itOtherappAttachmentService;

	@Autowired
	private TOtherappAttachmentMapper tOtherappAttachmentMapper;

	/** 基础功能不要直接写实现 */
	/**
	* 列表
	* @return
	*/
	private List<TPublicServiceIfind> list(TPublicServiceIfind TPublicServiceIfind) {
		return TPublicServiceIfindMapper.list(TPublicServiceIfind);
	}

	/**
	* 查询
	* @param id
	*/
	private TPublicServiceIfind getObjectById(Long id) {
		Query query = new Query();
		query.put("findId",id);
		return TPublicServiceIfindMapper.getObjectById(query);
	}

    /**
     * 分页查询
     * @param TPublicServiceIfind
     * @return
     */
	@Override
	public List<TPublicServiceIfind> listTPublicServiceIfind(TPublicServiceIfind TPublicServiceIfind) {
		return this.list(TPublicServiceIfind);
	}

    /**
     * 新增
     * @param TPublicServiceIfind
     * @return
     */
	@Override
	public int saveTPublicServiceIfind(TPublicServiceIfind TPublicServiceIfind) {
		return TPublicServiceIfindMapper.save(TPublicServiceIfind);
	}

    /**
     * 根据id查询
     * @param id
     * @return
     */
	@Override
	public TPublicServiceIfind getTPublicServiceIfindById(Long id) {
		return this.getObjectById(id);
	}

    /**
     * 修改
     * @param TPublicServiceIfind
     * @return
     */
	@Override
	public int updateTPublicServiceIfind(TPublicServiceIfind TPublicServiceIfind) {
		return TPublicServiceIfindMapper.update(TPublicServiceIfind);
	}

    /**
     * 删除
     * @param ids
     * @return
     */
	@Override
	public int batchRemove(Long[] ids) {
		int count = 0;
		for(Long id:ids) {
			count += TPublicServiceIfindMapper.remove(id);
		}
		return count;
	}

	@Override
	public String getMaxNum(){
		String numKey = BsUtils.getBsCacheKey(String.format("%s%s", BsConstants.CACHE_KEY_IFIND_NO));
		String num = "";
		if (!redisCache.keys().exists(numKey)) {
			TPublicServiceIfind ifind = new TPublicServiceIfind();
			ifind = TPublicServiceIfindMapper.getMaxNo(ifind);

			if(null == ifind || StringUtils.isNull(ifind.getFindCode())){
				num = "00001";
			}else{
				num = ifind.getFindCode().substring(ifind.getFindCode().length()-5,ifind.getFindCode().length());
			}
			redisCache.strings().setnx(numKey,Integer.parseInt(num));
		}
		redisCache.keys().expire(numKey,1,TimeUnit.DAYS);
		Long no = redisCache.strings().incrBy(numKey, 1L);
		return "FX"+BsUtils.formatMindNo(no,5);
	}

	/**
	 * 新增
	 * @param TPublicServiceIfind
	 * @return
	 */
	@Override
	@Transactional
	public int saveIfind(TPublicServiceIfind TPublicServiceIfind) {
		TPublicServiceIfind.setFindCode(this.getMaxNum());
		int result = TPublicServiceIfindMapper.save(TPublicServiceIfind);
		if(!CollectionUtils.isEmpty(TPublicServiceIfind.getAttachmentList())){
			for(TOtherappAttachment attachment : TPublicServiceIfind.getAttachmentList()){
				attachment.setBusinessId(TPublicServiceIfind.getFindId().toString());
				attachment.setAttachType(AttachEnums.AttachType.IFOUND.name());
				tOtherappAttachmentMapper.insertSelective(attachment);
			}
		}

		return result;
	}

	@Override
	public TPublicServiceIfind getIfindById(Long id) {
		TPublicServiceIfind ifind = this.getObjectById(id);

		if(null == ifind){
			return null;
		}
		ifind.setAttachmentList(itOtherappAttachmentService.listByBusinessIdAndType(Lists.newArrayList(ifind.getFindId()),AttachEnums.AttachType.IFOUND.name()));

		return ifind;
	}

	@Override
	@Transactional
	public int updateIfind(TPublicServiceIfind TPublicServiceIfind, String realName) {
		TPublicServiceIfind ifind = TPublicServiceIfindMapper.getObjectById(TPublicServiceIfind.getFindId());

		if(null == ifind){
			throw new ServiceException("我发现记录不存在");
		}
		return TPublicServiceIfindMapper.update(TPublicServiceIfind);
	}

}
