package com.ruoyi.system.domain.md.enums;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author vidar
 * date 2024/6/6
 * description
 **/
public enum OperatorType implements Operator{
    eq("eq", "等于") {
        public String execute(String fieldName) {
            return fieldName + " =";
        }
    },
    ne("ne", "不等于") {
        public String execute(String fieldName) {
            return fieldName + " <>";
        }
    },
    gt("gt", "大于") {
        public String execute(String fieldName) {
            return fieldName + " >";
        }
    },
    gte("gte", "大于等于") {
        public String execute(String fieldName) {
            return fieldName + " >=";
        }
    },
    lt("lt", "小于") {
        public String execute(String fieldName) {
            return fieldName + " <";
        }
    },
    lte("lte", "小于等于") {
        public String execute(String fieldName) {
            return fieldName + " <=";
        }
    },
    like("like", "相似") {
        public String execute(String fieldName) {
            return fieldName + " like";
        }
    };

    private String code;
    private String text;
    public static Map<String, OperatorType> maps = null;

    private OperatorType(String code, String text) {
        this.code = code;
        this.text = text;
    }

    public static OperatorType getByCode(String code) {
        return (OperatorType)maps.get(code);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    static {
        maps = new LinkedHashMap();
        OperatorType[] var0 = values();
        int var1 = var0.length;

        for(int var2 = 0; var2 < var1; ++var2) {
            OperatorType it = var0[var2];
            maps.put(it.getCode(), it);
        }

    }
}
