package com.ruoyi.system.service.operatingmanage.impl;

import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.sql.Query;
import com.ruoyi.system.domain.operatingmanage.TPublicServiceComInfo;
import com.ruoyi.system.domain.operatingmanage.TPublicServiceComRecruit;
import com.ruoyi.system.mapper.operatingmanage.TPublicServiceComRecruitMapper;
import com.ruoyi.system.service.operatingmanage.TPublicServiceComInfoService;
import com.ruoyi.system.service.operatingmanage.TPublicServiceComRecruitService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * 企业招聘
 * @author wujm<wujm@eazytec.com>
 */
@Service
public class TPublicServiceComRecruitServiceImpl implements TPublicServiceComRecruitService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Resource
	private TPublicServiceComRecruitMapper tPublicServiceComRecruitMapper;

	@Autowired
	private TPublicServiceComInfoService itPublicServiceComInfoService;

	/** 基础功能不要直接写实现 */
	/**
	* 列表
	* @return
	*/
	private List<TPublicServiceComRecruit> list(TPublicServiceComRecruit tPublicServiceComRecruit) {
		return tPublicServiceComRecruitMapper.list(tPublicServiceComRecruit);
	}

	/**
	* 查询
	* @param id
	*/
	private TPublicServiceComRecruit getObjectById(Long id) {
		Query query = new Query();
		query.put("postId",id);
		return tPublicServiceComRecruitMapper.getObjectById(query);
	}

    /**
     * 分页查询
     * @param tPublicServiceComRecruit
     * @return
     */
	@Override
	public List<TPublicServiceComRecruit> listTPublicServiceComRecruit(TPublicServiceComRecruit tPublicServiceComRecruit) {
		return this.list(tPublicServiceComRecruit);
	}

    /**
     * 新增
     * @param tPublicServiceComRecruit
     * @return
     */
	@Override
	public int saveTPublicServiceComRecruit(TPublicServiceComRecruit tPublicServiceComRecruit) {
		return tPublicServiceComRecruitMapper.save(tPublicServiceComRecruit);
	}

    /**
     * 根据id查询
     * @param id
     * @return
     */
	@Override
	public TPublicServiceComRecruit getTPublicServiceComRecruitById(Long id) {
		return this.getObjectById(id);
	}

    /**
     * 修改
     * @param tPublicServiceComRecruit
     * @return
     */
	@Override
	public int updateTPublicServiceComRecruit(TPublicServiceComRecruit tPublicServiceComRecruit) {
		return tPublicServiceComRecruitMapper.update(tPublicServiceComRecruit);
	}

    /**
     * 删除
     * @param ids
     * @return
     */
	@Override
	public int batchRemove(Long[] ids) {
		int count = 0;
		for(Long id:ids) {
			count += tPublicServiceComRecruitMapper.remove(id);
		}
		return count;
	}

	/**
	 * 新增
	 * @param tPublicServiceComRecruit
	 * @return
	 */
	@Override
	@Transactional
	public int saveComRecruit(TPublicServiceComRecruit tPublicServiceComRecruit, String userName) {
		TPublicServiceComInfo comInfo = tPublicServiceComRecruit.gettPublicServiceComInfo();
		comInfo.setCreateBy(userName);
		itPublicServiceComInfoService.saveTPublicServiceComInfo(comInfo);
		tPublicServiceComRecruit.setComId(comInfo.getComId());
		tPublicServiceComRecruit.setCreateBy(userName);
		int result = tPublicServiceComRecruitMapper.save(tPublicServiceComRecruit);

		return result;
	}

	@Override
	@Transactional
	public int updateComRecruit(TPublicServiceComRecruit tPublicServiceComRecruit, String userName){
		TPublicServiceComInfo comInfo = tPublicServiceComRecruit.gettPublicServiceComInfo();

		if(null == comInfo){
			throw new ServiceException("企业信息未传");
		}

		//未传企业id 则新增企业
		if(null == comInfo.getComId()){
			comInfo.setCreateBy(userName);
			itPublicServiceComInfoService.saveTPublicServiceComInfo(comInfo);
		}else{
			//有企业id 增更新企业信息
			comInfo.setUpdateBy(userName);
			comInfo.setUpdateTime(new Date());
			itPublicServiceComInfoService.updateTPublicServiceComInfo(comInfo);
		}

		tPublicServiceComRecruit.setComId(comInfo.getComId());
		tPublicServiceComRecruit.setUpdateBy(userName);
		tPublicServiceComRecruit.setUpdateTime(new Date());
		return tPublicServiceComRecruitMapper.update(tPublicServiceComRecruit);
	}

	/**
	 * 根据id查询
	 * @param id
	 * @return
	 */
	@Override
	public TPublicServiceComRecruit getComRecruitById(Long id) {
		TPublicServiceComRecruit comRecruit = this.getObjectById(id);

		comRecruit.settPublicServiceComInfo(
				itPublicServiceComInfoService.getTPublicServiceComInfoById(comRecruit.getComId()));

		return comRecruit;
	}


}
