package com.ruoyi.system.service.grid.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.AdDateUtils;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.domain.grid.*;
import com.ruoyi.system.domain.task.TkCommonTask;
import com.ruoyi.system.domain.task.TkCommonTaskExample;
import com.ruoyi.system.domain.visit.VisitFreeInterview;
import com.ruoyi.system.domain.visit.VisitFreeInterviewExample;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.grid.GridWorkReportItemMapper;
import com.ruoyi.system.mapper.grid.GridWorkReportMapper;
import com.ruoyi.system.mapper.system.SysDeptMapper;
import com.ruoyi.system.mapper.task.ext.TkCommonTaskExtMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.grid.*;
import com.ruoyi.system.service.system.ISysUserService;
import com.ruoyi.system.service.visit.VisitFreeInterviewService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.*;

/**
 * @author condey
 * @version $$package: com.ruoyi.system.service.grid.impl, v 0.1 2024/6/24 4:33 PM condey Exp $$
 */
@Service
@MyBaseService
public class GridWorkReportServiceImpl extends BaseServiceImpl<GridWorkReportMapper, GridWorkReport, GridWorkReportExample> implements GridWorkReportService {

    @Autowired
    private GridWorkReportItemMapper reportItemMapper;

    @Autowired
    private GridRegionService gridRegionService;

    @Autowired
    private GridCompanyService gridCompanyService;

    @Autowired
    private GridShopService gridShopService;

    @Autowired
    private GridHouseService gridHouseService;

    @Autowired
    private GridPeopleService gridPeopleService;

    @Autowired
    private GridRegionUserService gridRegionUserService;

    @Autowired
    private VisitFreeInterviewService visitFreeInterviewService;

    @Autowired
    private GridItemDailyFacadeService gridItemDailyFacadeService;

    @Autowired
    private TkCommonTaskExtMapper tkCommonTaskExtMapper;

    @Autowired
    private ISysUserService sysUserService;

    @Autowired
    private SysDeptMapper deptMapper;

    @Override
    @Transactional
    public Long createReport(GridWorkReport report) {

        // 检查是否有老数据， 如果有的话就删除
        checkAndDelOldData(report);

        report.setId(null);
        report.setCreateTime(new Date());

        insert(report);

        Long reportId = report.getId();

        GridWorkReportItem reportItem = new GridWorkReportItem();
        reportItem.setReportId(reportId);

        /////// 构造内容
        JSONObject content = createContent(report);
        reportItem.setContent(content.toJSONString());
        reportItemMapper.insert(reportItem);

        return reportId;
    }

    private JSONObject createContent(GridWorkReport report) {

        JSONObject contentObject = new JSONObject();

        /////////////// 数据采集情况 /////////////////
        contentObject.put("acq", createAcq(report));
        /////////////// 走访情况 ////////////////////
        contentObject.put("visit", createVisit(report));
        /////////////// 工单分析 ////////////////////
        contentObject.put("task", createTask(report));
        return contentObject;
    }

    /**
     * 组装- 数据采集情况
     *
     * @param report
     * @return
     */
    private JSONObject createAcq(GridWorkReport report) {

        JSONObject acqObject = new JSONObject();

        // 获取所有的二级网格
        List<GridRegion> regionList = getRegionList("2");
        Map<String, Integer> wgCodeSummaryMap = new HashMap<>();

        JSONArray acqListItemArray = new JSONArray();

        // 获取所有的三级网格并加载成map
        List<GridRegion> thirdRegionList = getRegionList("3");
        Map<String, List<String>> thirdRegionMap = createRegionMap(thirdRegionList);

        // 获取所有的四级网格, 并且按照四级网格分类
        List<GridRegion> fourRegionList = getRegionList("4");
        Map<String, List<String>> fourRegionMap = createRegionMap(fourRegionList);

        // 计算2级网格下面有多少4级网格
        for (String key : thirdRegionMap.keySet()) {
            Integer number = 0;

            for (String fourKey : thirdRegionMap.get(key)) {
                if (fourRegionMap.containsKey(fourKey)) {
                    number = number + fourRegionMap.get(fourKey).size();
                }
            }
            wgCodeSummaryMap.put(key, number);
        }

        // 一些总计数据
        Integer allRegionNum = 0;
        Integer allCompanyNum = 0;
        Integer allShopNum = 0;
        Integer allHouseNum = 0;
        Integer allPeopleNum = 0;

        for (GridRegion region : regionList) {

            JSONObject acqItem = new JSONObject();
            acqItem.put("regionCode", region.getWgCode());
            acqItem.put("regionName", region.getWgName());

            // 地块
            if (wgCodeSummaryMap.containsKey(region.getWgCode())) {
                Integer hasRegionNum = wgCodeSummaryMap.get(region.getWgCode());
                acqItem.put("hasRegionNum", hasRegionNum);
                allRegionNum = allRegionNum + hasRegionNum;
            } else {
                acqItem.put("hasRegionNum", 0);
            }

            // 企业
            int hasCompanyNum = gridCompanyService.countAll(region.getWgCode());
            acqItem.put("hasCompanyNum", hasCompanyNum);
            allCompanyNum = allCompanyNum + hasCompanyNum;

            // 店铺
            int hasShopNum = gridShopService.countAll(region.getWgCode());
            acqItem.put("hasShopNum", hasShopNum);
            allShopNum = allShopNum + hasShopNum;

            // 房屋
            int hasHouseNum = gridHouseService.countAll(region.getWgCode());
            acqItem.put("hasHouseNum", hasHouseNum);
            allHouseNum = allHouseNum + hasHouseNum;

            // 人员
            int hasPeopleNum = gridPeopleService.countAll(region.getWgCode());
            acqItem.put("hasPeopleNum", hasPeopleNum);
            allPeopleNum = allPeopleNum + hasPeopleNum;
            acqListItemArray.add(acqItem);
        }
        acqObject.put("listItem", acqListItemArray);

        // 总计数据
        acqObject.put("allRegionNum", allRegionNum);
        acqObject.put("allCompanyNum", allCompanyNum);
        acqObject.put("allShopNum", allShopNum);
        acqObject.put("allHouseNum", allHouseNum);
        acqObject.put("allPeopleNum", allPeopleNum);
        return acqObject;

    }

    private Map<String, List<String>> createRegionMap(List<GridRegion> regionList) {

        Map<String, List<String>> regionMap = new HashMap<>();
        for (GridRegion region : regionList) {

            if (regionMap.containsKey(region.getWgParentId())) {
                List<String> wgCodeList = regionMap.get(region.getWgParentId());
                wgCodeList.add(region.getWgCode());
            } else {
                List<String> wgCodeList = new ArrayList<>();
                wgCodeList.add(region.getWgCode());
                regionMap.put(region.getWgParentId(), wgCodeList);
            }
        }
        return regionMap;
    }

    private List<GridRegion> getRegionList(String level) {

        GridRegionExample ex = new GridRegionExample();
        GridRegionExample.Criteria ca = ex.createCriteria();
        ca.andLevelEqualTo(level);
        ca.andIsValidEqualTo("1");
        ca.andWgTypeEqualTo("1");
        return gridRegionService.selectByExample(ex);
    }

    /**
     * 组装- 走访情况
     *
     * @param report
     * @return
     */
    private JSONObject createVisit(GridWorkReport report) {

        String year = report.getYear();
        String month = report.getMonth();

        // 获取周数
        YearMonth yearMonth = YearMonth.of(Integer.valueOf(report.getYear()), Integer.valueOf(report.getMonth()) - 1);
        Map<Integer, AdDateUtils.WeekData> weekDataMap = AdDateUtils.weeks(yearMonth);

        JSONObject regionObject = new JSONObject();
        regionObject.put("weekNum", weekDataMap.keySet().size());

        List<GridRegion> regionList = getRegionList("2");

        JSONArray regionListArray = new JSONArray();

        // 获取这个月的所有走访
        Integer allVisitCount = getAllVisitNumber(year, month);

        for (GridRegion region : regionList) {

            JSONObject regionItem = new JSONObject();
            regionItem.put("regionCode", region.getWgCode());
            regionItem.put("regionName", region.getWgName());

            // 获取所有三级网格员
            List<GridRegionUser> regionUsers = gridRegionUserService.selectUsers(region.getWgCode());
            if (!CollectionUtils.isEmpty(regionUsers)) {

                JSONArray regionUserArray = new JSONArray();
                for (GridRegionUser regionUser : regionUsers) {
                    if (regionUser.getWgId().length() > 12) {
                        // 关联的wgId大于12，才是三级网格员
                        JSONObject userObject = new JSONObject();

                        userObject.put("userId", regionUser.getUserId());
                        userObject.put("userName", regionUser.getYlzd1());

                        // 获取这个userId 所有的走访日志
                        VisitFreeInterviewExample example = new VisitFreeInterviewExample();
                        VisitFreeInterviewExample.Criteria ca = example.createCriteria();

                        ca.andWgyCodeEqualTo(regionUser.getWgId());
                        ca.andWgyNameEqualTo(regionUser.getYlzd1());
                        ca.andInterviewTimeLike(year + "-" + month + "%");
                        ca.andVisitTypeEqualTo("F");
                        ca.andIsValidEqualTo("1");

                        List<VisitFreeInterview> interviews = visitFreeInterviewService.selectByExample(example);

                        // 比例
                        if (!CollectionUtils.isEmpty(interviews)) {

                            int count = interviews.size();

                            NumberFormat numberFormat = NumberFormat.getInstance();
                            numberFormat.setMaximumFractionDigits(0);
                            String result = numberFormat.format((float) count / (float) allVisitCount * 100);
                            userObject.put("scale", result);

                        } else {
                            userObject.put("scale", "0");
                        }

                        Map<Integer, Integer> interviewMap = new HashMap<>();
                        if (!CollectionUtils.isEmpty(interviews)) {
                            for (VisitFreeInterview interview : interviews) {

                                Integer weekKey = getKeyInterviewMap(interview, weekDataMap);

                                if (weekKey != null) {
                                    if (interviewMap.containsKey(weekKey)) {
                                        Integer num = interviewMap.get(weekKey);
                                        interviewMap.put(weekKey, num);
                                    } else {
                                        interviewMap.put(weekKey, 1);
                                    }
                                }
                            }
                        }
                        userObject.put("num", interviewMap);
                        regionUserArray.add(userObject);
                    }
                }
                regionItem.put("userArray", regionUserArray);
            }
            regionListArray.add(regionItem);
        }
        regionObject.put("listItem", regionListArray);
        return regionObject;
    }

    private Integer getAllVisitNumber(String year, String month) {
        VisitFreeInterviewExample example = new VisitFreeInterviewExample();
        VisitFreeInterviewExample.Criteria ca = example.createCriteria();
        ca.andInterviewTimeLike(year + "-" + month + "%");
        ca.andVisitTypeEqualTo("F");
        ca.andIsValidEqualTo("1");
        return visitFreeInterviewService.countByExample(example);
    }

    private Integer getKeyInterviewMap(VisitFreeInterview interview, Map<Integer, AdDateUtils.WeekData> weekDataMap) {

        String interviewTime = interview.getInterviewTime().substring(0, 10);
        LocalDate localDate = LocalDate.parse(interviewTime, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        for (Integer weekKey : weekDataMap.keySet()) {

            AdDateUtils.WeekData weekData = weekDataMap.get(weekKey);
            if (weekData.isIn(localDate)) {
                return weekKey;
            }
        }
        return null;
    }

    /**
     * 组装 - 工单分析
     *
     * @param report
     * @return
     */
    private JSONObject createTask(GridWorkReport report) {
        YearMonth yearMonth = YearMonth.of(Integer.parseInt(report.getYear()),Integer.parseInt(report.getMonth()));

        JSONObject taskObject = new JSONObject();
        taskObject.put("typeSummary", createTypeSummary(report));

        TkCommonTaskExample example = new TkCommonTaskExample();
        TkCommonTaskExample.Criteria ca = example.createCriteria();
        ca.andStandby1EqualTo("0");
        LocalDateTime startTime = yearMonth.atDay(1).atTime(0,0,0);
        LocalDateTime endTime = yearMonth.atEndOfMonth().atTime(23,59,59);
        ca.andCreateTimeBetween(
                DateUtils.toDate(startTime),DateUtils.toDate(endTime)
        );
        List<TkCommonTask> taskList = tkCommonTaskExtMapper.selectByExample(example);

        // 类型明细
        JSONArray typeListItem = createTypeListItem(taskList);
        taskObject.put("typeListItem", typeListItem);

        // 网格工单
        JSONArray gridListItem = createGridListItem(taskList);
        taskObject.put("gridListItem", gridListItem);

        // 部门工单
        JSONArray depListItem = createDepListItem(taskList);
        taskObject.put("depListItem", depListItem);

        return taskObject;
    }

    private List<Map<String, String>> createTypeSummary(GridWorkReport report) {

        Map<String, Date> dateMap = getMonthFirstAndLastDay(report.getYear(), report.getMonth());
        Date firstDay = dateMap.get("firstDate");
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Map<String, Object> para = new HashMap<String, Object>();
        para.put("startDate", firstDay);
        para.put("wgCode", "320282118");
        List<TkCommonTask> result = tkCommonTaskExtMapper.matterTask(para);
        List<Map<String, Object>> allMatter = gridItemDailyFacadeService.getFirstDwRcsxList();
        List<String> firstMatter = new ArrayList<>();

        for (Map<String, Object> mapTemp : allMatter) {
            List<Map<String, Object>> mapTempNet = (List<Map<String, Object>>) mapTemp.get("children");
            for (Map<String, Object> mapStr : mapTempNet) {
                firstMatter.add(String.valueOf(mapStr.get("sxmc")));
            }
        }

        for (int i = 0; i < firstMatter.size(); i++) {
            Map<String, String> map = new HashMap<String, String>();
            if (result.isEmpty()) {
                map.put("name", firstMatter.get(i));
                map.put("value", "0");
            } else {
                for (TkCommonTask tkCommonTask : result) {
                    if (StringUtils.isNotBlank(tkCommonTask.getMatterName()) &&
                            tkCommonTask.getMatterName().equals(firstMatter.get(i))) {
                        map.put("name", firstMatter.get(i));
                        map.put("value", tkCommonTask.getNum());
                        break;
                    } else {
                        map.put("name", firstMatter.get(i));
                        map.put("value", "0");
                    }
                }
            }
            list.add(map);
        }
        return list;
    }

    private Map<String, Date> getMonthFirstAndLastDay(String year, String month) {
        Date firstDate = null;
        Date lastDate = null;
        Calendar cal_1 = Calendar.getInstance();
        Calendar cal_2 = Calendar.getInstance();
        if (StringUtils.isBlank(year) && StringUtils.isBlank(month)) {
            cal_1.set(Calendar.DAY_OF_MONTH, 1);

            cal_2.set(Calendar.DAY_OF_MONTH, cal_1.getActualMaximum(Calendar.DAY_OF_MONTH));

        } else if (!StringUtils.isBlank(year) && StringUtils.isBlank(month)) {
            cal_1.set(Calendar.YEAR, Integer.valueOf(year));//设置年
            cal_1.set(Calendar.DAY_OF_YEAR, cal_1.getActualMinimum(Calendar.DAY_OF_YEAR));

            cal_2.set(Calendar.YEAR, Integer.valueOf(year));//设置年
            cal_2.set(Calendar.DAY_OF_YEAR, cal_1.getActualMaximum(Calendar.DAY_OF_YEAR));
        } else {
            cal_1.set(Calendar.YEAR, Integer.valueOf(year));//设置年
            cal_1.set(Calendar.MONTH, Integer.valueOf(month) - 1);//设置月，月设置要-1
            cal_1.set(Calendar.DAY_OF_MONTH, 1);

            cal_2.set(Calendar.YEAR, Integer.valueOf(year));//设置年
            cal_2.set(Calendar.MONTH, Integer.valueOf(month) - 1);//设置月，月设置要-1
            cal_2.set(Calendar.DAY_OF_MONTH, cal_2.getActualMaximum(Calendar.DAY_OF_MONTH));
        }

        cal_1.set(Calendar.MINUTE, 0);
        cal_1.set(Calendar.SECOND, 0);
        cal_1.set(Calendar.HOUR_OF_DAY, 0);
        firstDate = cal_1.getTime();

        cal_2.set(Calendar.MINUTE, 59);
        cal_2.set(Calendar.SECOND, 59);
        cal_2.set(Calendar.HOUR_OF_DAY, 23);
        lastDate = cal_2.getTime();

        Map<String, Date> dateMap = new HashMap<>();
        dateMap.put("firstDate", firstDate);
        dateMap.put("lastDate", lastDate);
        return dateMap;
    }

    private JSONArray createTypeListItem(List<TkCommonTask> taskList) {


        Map<String, JSONObject> typeListMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(taskList)) {
            for (TkCommonTask task : taskList) {
                if (StringUtils.isBlank(task.getMatterName())) {
                    continue;
                }
                String key = task.getMatterName();
                boolean hasFinish = task.getTkStatus() > 40;

                if (typeListMap.containsKey(key)) {
                    JSONObject typeObject = typeListMap.get(key);

                    typeObject.put("all", typeObject.getIntValue("all") + 1);

                    if (hasFinish) {
                        typeObject.put("finish", typeObject.getIntValue("finish") + 1);
                    } else {
                        typeObject.put("doing", typeObject.getIntValue("doing") + 1);
                    }

                } else {

                    JSONObject typeObject = new JSONObject();
                    typeObject.put("matterName", key);
                    typeObject.put("all", 1);
                    typeObject.put("finish", hasFinish ? 1 : 0);
                    typeObject.put("doing", hasFinish ? 0 : 1);
                    typeListMap.put(key, typeObject);
                }
            }
        }

        List<JSONObject> objectList = new ArrayList<>();
        for (JSONObject object : typeListMap.values()) {

            int finish = object.getIntValue("finish");
            int all = object.getIntValue("all");

            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(0);
            String result = numberFormat.format((float) finish / (float) all * 100);
            object.put("scale", result);
            objectList.add(object);
        }

        // 排序
        Collections.sort(objectList, (o1, o2) -> {
            int o1all = o1.getIntValue("all");
            int o2all = o1.getIntValue("all");
            return o1all - o2all;
        });
        return JSONArray.parseArray(JSON.toJSONString(objectList));
    }

    private JSONArray createGridListItem(List<TkCommonTask> taskList) {

        Map<String, JSONObject> taskMap = createTaskMap(taskList, "1");
        JSONArray taskArray = new JSONArray();
        // 获取一个工单网格员的列表
        List<GridRegion> regionList = getRegionList("2");
        for (GridRegion region : regionList) {
            // 获取所有三级网格员
            List<GridRegionUser> regionUsers = gridRegionUserService.selectUsers(region.getWgCode());
            JSONArray regionUserArray = new JSONArray();
            for (GridRegionUser regionUser : regionUsers) {
                if (regionUser.getWgId().length() > 12
                        && taskMap.containsKey(regionUser.getUserId())) {
                    JSONObject taskObject = taskMap.get(regionUser.getUserId());
                    regionUserArray.add(taskObject);
                }
            }

            if (regionUserArray.size() > 0) {
                JSONObject regionObject = new JSONObject();
                regionObject.put("userArray", regionUserArray);
                regionObject.put("regionName", region.getWgName());
                regionObject.put("regionCode", region.getWgCode());
                taskArray.add(regionObject);
            }
        }

        return taskArray;
    }

    private JSONArray createDepListItem(List<TkCommonTask> taskList) {

        Map<String, JSONObject> taskMap = createTaskMap(taskList, "2");
        JSONArray taskArray = new JSONArray();

        // 获取所有的部门
        List<SysDept> deptList = deptMapper.selectByParentId(100L);

        for (SysDept sysDept : deptList) {

            List<SysUser> sysUserList = sysUserService.listByDepId(sysDept.getDeptId());
            JSONArray deptUserArray = new JSONArray();
            for (SysUser sysUser : sysUserList) {
                if (taskMap.containsKey(sysUser.getUserId())) {
                    JSONObject taskObject = taskMap.get(sysUser.getUserId());
                    deptUserArray.add(taskObject);
                }
            }

            if (deptUserArray.size() > 0) {
                JSONObject regionObject = new JSONObject();
                regionObject.put("userArray", deptUserArray);
                regionObject.put("deptName", sysDept.getDeptName());
                regionObject.put("deptCode", sysDept.getDeptId());
                taskArray.add(regionObject);
            }

        }
        return taskArray;
    }

    private Map<String, JSONObject> createTaskMap(List<TkCommonTask> taskList, String userType) {

        Map<String, JSONObject> taskMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(taskList)) {
            for (TkCommonTask task : taskList) {
                if (StringUtils.isBlank(task.getPerformUserType())
                        || !task.getPerformUserType().equals(userType)) {
                    continue;
                }
                String userId = task.getPerformUserId();
                boolean hasFinish = task.getTkStatus() > 40;

                if (taskMap.containsKey(userId)) {
                    JSONObject userObject = taskMap.get(userId);
                    userObject.put("all", userObject.getIntValue("all") + 1);
                    if (hasFinish) {
                        userObject.put("finish", userObject.getIntValue("finish") + 1);
                    } else {
                        userObject.put("doing", userObject.getIntValue("doing") + 1);
                    }
                } else {
                    JSONObject userObject = new JSONObject();
                    userObject.put("name", task.getPerformUserName());
                    userObject.put("all", 1);
                    userObject.put("finish", hasFinish ? 1 : 0);
                    userObject.put("doing", hasFinish ? 0 : 1);
                    taskMap.put(userId, userObject);
                }
            }
        }

        for (JSONObject object : taskMap.values()) {

            Integer finish = object.getIntValue("finish");
            Integer all = object.getIntValue("all");

            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(0);
            String result = numberFormat.format((float) finish / (float) all * 100);
            object.put("scale", result);
        }
        return taskMap;
    }


    /**
     * 删除老数据
     */
    private void checkAndDelOldData(GridWorkReport report) {

        GridWorkReportExample ex = new GridWorkReportExample();
        GridWorkReportExample.Criteria ca = ex.createCriteria();
        ca.andYearEqualTo(report.getYear());
        ca.andMonthEqualTo(report.getMonth());

        List<GridWorkReport> originList = this.selectByExample(ex);

        if (!CollectionUtils.isEmpty(originList)) {
            // 先删除
            GridWorkReport origin = originList.get(0);

            this.deleteByPrimaryKey(origin.getId().intValue());

            GridWorkReportItemExample itemEx = new GridWorkReportItemExample();
            GridWorkReportItemExample.Criteria itemCa = itemEx.createCriteria();
            itemCa.andReportIdEqualTo(origin.getId());
            reportItemMapper.deleteByExample(itemEx);
        }
    }

    @Override
    public List<GridWorkReport> queryList(String year, String month) {

        GridWorkReportExample ex = new GridWorkReportExample();
        GridWorkReportExample.Criteria ca = ex.createCriteria();
        if (StringUtils.isNotBlank(year)) {
            ca.andYearEqualTo(year);
        }
        if (StringUtils.isNotBlank(month)) {
            ca.andMonthEqualTo(month);
        }
        ex.setOrderByClause(" create_time desc");
        return this.selectByExample(ex);
    }

    @Override
    public GridWorkReport detail(Long id) {

        GridWorkReport report = selectByPrimaryKey(id);

        if (report != null) {

            GridWorkReportItemExample ex = new GridWorkReportItemExample();
            GridWorkReportItemExample.Criteria ca = ex.createCriteria();
            ca.andReportIdEqualTo(id);

            List<GridWorkReportItem> reportItemList = reportItemMapper.selectByExampleWithBLOBs(ex);

            if (!CollectionUtils.isEmpty(reportItemList)) {
                report.setContentItem(JSON.parseObject(reportItemList.get(0).getContent()));
            }
        }
        return report;
    }
}
