package com.ruoyi.system.domain.form.enums;

import java.util.HashMap;
import java.util.Map;

public enum EnumFormStatus {
    normal(1,"正常"),
    delete(0,"删除"),
    recycler(2,"回收站"),
    ;

    public int code;
    public String text;

    EnumFormStatus(int code, String text) {
        this.code = code;
        this.text = text;
    }

    public static Map<Integer, EnumFormStatus> maps = null;

    static
    {
        maps = new HashMap<>();
        for(EnumFormStatus it : EnumFormStatus.values())
        {
            maps.put(it.getCode(),it);
        }
    }

    public static EnumFormStatus getByCode(int code)
    {
        return maps.get(code);
    }

    public int getCode() {
        return code;
    }

    public void setCode(byte code) {
        this.code = code;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

}
