package com.ruoyi.system.domain.grid.enums;

public enum GridCompanyEconomyPerMuResultEnum {

    ZERO_TO_ONE("0~1", "亩均低于1W"),

    ONE_TO_THREE("1~3", "亩均1W-3W"),

    OVER_THREE("3", "亩均高于3W");

    private String code;

    private String value;

    private GridCompanyEconomyPerMuResultEnum(String code, String value) {
        this.code = code;
        this.value = value;
    }

    public static GridCompanyEconomyPerMuResultEnum getByCode(String code) {
        if (code == null || code.trim().length() <= 0) {
            return null;
        }
        for (int i = 0; i < values().length; i++) {
            if (values()[i].code.equals(code)) {
                return values()[i];
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }
}
