package com.ruoyi.system.service.task.impl;

import com.ruoyi.system.domain.task.TkCommonLeader;
import com.ruoyi.system.domain.task.TkCommonLeaderExample;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.task.TkCommonLeaderMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.task.TkCommonLeaderService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
* @author Cesar
* @date  ${cTime}
* @desc TkCommonLeaderService实现
*/
@Service
@MyBaseService
public class TkCommonLeaderServiceImpl extends BaseServiceImpl<TkCommonLeaderMapper, TkCommonLeader, TkCommonLeaderExample> implements TkCommonLeaderService {

    private static final Logger LOGGER = LoggerFactory.getLogger(TkCommonLeaderServiceImpl.class);

    @Override
    public void deleteByTaskId(String taskId) {
        if (StringUtils.isBlank(taskId)){
            return;
        }
        TkCommonLeaderExample example = new TkCommonLeaderExample();
        example.createCriteria().andTkIdEqualTo(taskId);
        this.deleteByExample(example);
    }
}