package com.ruoyi.system.service.video.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.system.domain.video.VideoDeviceChannel;
import com.ruoyi.system.domain.video.ext.ChannelUrlInfo;
import com.ruoyi.system.mapper.video.VideoDeviceChannelMapper;
import com.ruoyi.system.service.video.IccTokenService;
import com.ruoyi.system.service.video.VideoDeviceChannelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * <p>
 * 监控设备包含通道 服务实现类
 * </p>
 *
 * @author lb
 * @since 2024-07-31
 */
@Service
public class VideoDeviceChannelServiceImpl extends ServiceImpl<VideoDeviceChannelMapper, VideoDeviceChannel> implements VideoDeviceChannelService {

        @Autowired
        private VideoDeviceChannelMapper videoDeviceChannelMapper;

        @Autowired
        private IccTokenService iccTokenService;

        public List<VideoDeviceChannel> selectVideoDeviceChannelList(VideoDeviceChannel videoDeviceChannel)
        {
            return videoDeviceChannelMapper.selectVideoDeviceChannelList(videoDeviceChannel);
        };

        @Override
        public VideoDeviceChannel selectVideoDeviceChannelById(Long id)
        {
            return videoDeviceChannelMapper.selectVideoDeviceChannelById(id);
        };

        @Override
        public int InsertVideoDeviceChannel(VideoDeviceChannel  videoDeviceChannel)
        {
            return videoDeviceChannelMapper.InsertVideoDeviceChannel(videoDeviceChannel);
        };

        @Override
        public int UpdateVideoDeviceChannel(VideoDeviceChannel  videoDeviceChannel)
        {
            return videoDeviceChannelMapper.UpdateVideoDeviceChannel(videoDeviceChannel);
        };

        @Override
        public int DeleteVideoDeviceChannelByIds(Long[] ids)
        {
            return videoDeviceChannelMapper.DeleteVideoDeviceChannelByIds(ids);
        };

        @Override
        public List<ChannelUrlInfo> selectChannelList(VideoDeviceChannel videoDeviceChannel){
                return videoDeviceChannelMapper.selectChannelList(videoDeviceChannel);
        }

        public int UpdateDatabaseInfo(VideoDeviceChannel videoDeviceChannel){
                return videoDeviceChannelMapper.UpdateDatabaseInfo(videoDeviceChannel);
        }

        public int getVideoCount(String type){
                return videoDeviceChannelMapper.getVideoCount(type);
        }

        public int getCount(String type){
                return videoDeviceChannelMapper.getCount(type);
        }

        public String getVideoToken() throws Exception {
                return iccTokenService.getToken();
        }

        public int position(String channelId, int position){
                return videoDeviceChannelMapper.position(channelId,position);
        }

        public int positionById(String channelId){
                return videoDeviceChannelMapper.positionById(channelId);
        }

}
