package com.ruoyi.system.service.task.impl;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtil;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.domain.grid.GridItemDaily;
import com.ruoyi.system.domain.grid.GridItemDailyExample;
import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.grid.GridRegionExample;
import com.ruoyi.system.domain.task.*;
import com.ruoyi.system.domain.task.request.TkResetRequest;
import com.ruoyi.system.service.grid.GridItemDailyService;
import com.ruoyi.system.service.grid.GridRegionService;
import com.ruoyi.system.service.system.ISysRoleService;
import com.ruoyi.system.service.system.ISysUserService;
import com.ruoyi.system.service.task.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author vidar
 * date 2024/6/14
 * description
 **/
@Slf4j
@Service
public class TaskServiceImpl implements TaskService {
    @Resource
    private TkCommonTaskService tkCommonTaskService;
    @Resource
    private GridItemDailyService bsRcsxbService;
    @Resource
    private ISysRoleService sysRoleService;
    @Resource
    private ISysUserService userService;
    @Resource
    private TkRoundMatterService tkRoundMatterService;
    @Resource
    private TkCommonDiaoduService tkCommonDiaoduService;
    @Resource
    private GridRegionService bsWgxxbService;
    @Resource
    private TkCommonTaskDynamicService tkCommonTaskDynamicService;
    @Resource
    private TkCommonAssignedService tkCommonAssignedService;
    @Resource
    private TkCommonLeaderService tkCommonLeaderService;
    @Resource
    private TkCommonQianpiService tkCommonQianpiService;
    @Resource
    private TkCommonReceiveService tkCommonReceiveService;

    @Override
    @Transactional
    public String add(TkCommonTask tkCommonTask) {
        tkCommonTask.setStandby5("0");
        tkCommonTask.setIsYouxiao(0);
        tkCommonTask.setIsHst(0);
        // 如果有巡查id的话则根据这个巡查id查询数据库中是否有这条数据。如果有则不让创建。没有继续走下去
        if (StringUtils.isNotEmpty(tkCommonTask.getRoundSubtaskId())) {
            TkCommonTaskExample tkCommonTaskExample = new TkCommonTaskExample();
            TkCommonTaskExample.Criteria criteria = tkCommonTaskExample.createCriteria();
            criteria.andRoundSubtaskIdEqualTo(tkCommonTask.getRoundSubtaskId());
            criteria.andStandby1EqualTo("0");
            int count = tkCommonTaskService.countByExample(tkCommonTaskExample);
            if (count > 0) {
                throw new ServiceException("关联巡查已发布任务，请不要重复发布",400);
            }
        }
        tkCommonTask.setReleaseUserRoleNum(Integer.parseInt(tkCommonTask.getLoginUserRole()));
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String releaseTime = sdf.format(tkCommonTask.getReleaseTime());
            tkCommonTask.setReleaseTime(sdf.parse(releaseTime));
        } catch (Exception e) {
            log.error("业务异常",e);
        }
        String uuid = UUID.randomUUID().toString();
        tkCommonTask.setId(uuid);
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String dateNowStr = sdf.format(d);
        tkCommonTask.setTkId(dateNowStr.substring(0, 15));
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd:HH:mm:ss");
        String now = sdf2.format(d);
        try {
            tkCommonTask.setCreateTime(sdf2.parse(now));
        } catch (Exception e) {
            log.error("业务异常",e);
        }
        //获取父网格id和name
        setWgCodeAndWgName(tkCommonTask);
        if (StringUtils.isNotBlank(tkCommonTask.getMatterId())) {
            setMatterIdAndMatterName(tkCommonTask);
            //获取父网格id和name
        }

        //创建上报实体类
        TkCommonReport tkCommonReport = new TkCommonReport();
        tkCommonReport.setId(UUID.randomUUID().toString());
        tkCommonReport.setCommonTkId(tkCommonTask.getId());
        tkCommonReport.setCreateTime(new Date());
        String roleCode = "";//

        SimpleDateFormat sdf3 = new SimpleDateFormat("yyyy-MM-dd");
        Date assignedEndTime = null;
        try {
            String format = sdf3.format(new Date());
            assignedEndTime = sdf3.parse(format);
        } catch (Exception e) {
            log.error("业务异常",e);
        }
        //创建指派实体类 如果是自行处理就得保存  自己指派给自己
        TkCommonAssigned tkCommonAssigned = null;

        //0自行处理-1上报上级-2上报中心-3指派下级
        if (tkCommonTask.getHandleType() == 0) {
            tkCommonTask.setTkStatus(20);//任务处理状态是20
            tkCommonTask.setAssignedEndTime(assignedEndTime);//处理完成时间

            tkCommonAssigned = new TkCommonAssigned();//任务指派实体类
            tkCommonAssigned.setId(UUID.randomUUID().toString());
            tkCommonAssigned.setCommonTkId(tkCommonTask.getId());
            tkCommonAssigned.setAssignedUserId(tkCommonTask.getReleaseUserId());//指派人id
            tkCommonAssigned.setAssignedUserName(tkCommonTask.getReleaseUserName());//指派人姓名
            tkCommonAssigned.setAssignedEndTime(new Date());
            tkCommonAssigned.setAssignedRole(Integer.parseInt(tkCommonTask.getLoginUserRole()));//指派人角色等级
            tkCommonAssigned.setBeassignedUserId(tkCommonTask.getReleaseUserId());//被指派人用户id
            tkCommonAssigned.setBeassignedUserName(tkCommonTask.getReleaseUserName());//被指派人用户名
            tkCommonAssigned.setBeassignedRole(Integer.parseInt(tkCommonTask.getLoginUserRole()));//被指派人角色等级
            tkCommonAssigned.setAssignedStatus(1);//没数据就设为 1

            //任务上报到哪一级。3三级 2二级 1一级 0中心
        } else if (tkCommonTask.getHandleType() == 1) {//上报上级
            tkCommonTask.setTkStatus(10);
            if (tkCommonTask.getLoginUserRole().equals("2")) {
                tkCommonTask.setStandby2("0");
                tkCommonReport.setTolevel("0");
                roleCode = "centerman";
            } else {
                if (tkCommonTask.getLoginUserRole().equals("1")) {//中心
                    tkCommonTask.setStandby2("0");
                    tkCommonReport.setTolevel("0");
                    roleCode = "centerman";
                } else if (tkCommonTask.getLoginUserRole().equals("3")) {//2级
                    tkCommonTask.setStandby2("2");
                    tkCommonReport.setTolevel("2");
                    //roleCode="twogrid";  只要中心才自动指派
                }
            }

        } else if (tkCommonTask.getHandleType() == 2) {//上报中心
            tkCommonTask.setTkStatus(10);
            tkCommonTask.setStandby2("0");
            tkCommonReport.setTolevel("0");
            roleCode = "centerman";
        } else if (tkCommonTask.getHandleType() == 3) {//指派下级
            tkCommonTask.setTkStatus(10);
        }

        String now2 = sdf2.format(d);
        try {
            tkCommonAssigned.setCreateTime(sdf2.parse(now2));
        } catch (Exception e) {
            //log.error("业务异常",e);
        }
        tkCommonTask.setStandby1("0");
        tkCommonTask.setCreateBy(tkCommonTask.getReleaseUserId());
        AjaxResult result = new AjaxResult();
        //自动指派逻辑
        List<GridItemDaily> bsRcsxbs = new ArrayList<GridItemDaily>();//自行指派的数据
        //查找管理员
        if ((tkCommonTask.getHandleType() != 0 || tkCommonTask.getHandleType() != 3) && !roleCode.equals("")) {//不为自行处理 或者不为指派下级
            //（网格分类：城乡综合网格cx、企业网格qy、资产网格zc  其他qt

            GridItemDailyExample example = new GridItemDailyExample();
            GridItemDailyExample.Criteria criteria1 = example.createCriteria();
            criteria1.andIsValidEqualTo("1");
            criteria1.andIdEqualTo(tkCommonTask.getMatterId() == null ? "" : tkCommonTask.getMatterId());
            bsRcsxbs = bsRcsxbService.selectByExample(example);//指派的数据
            sysRoleService.getUserByRoleCode(roleCode,result);
            //-----------------------网格代码

        }

        //数据 上报上级的接收人数据 所以当前登录角色为2级 就查询中心的用户。
        AjaxResult result2 = new AjaxResult();//根据角色获取用户们
        if (tkCommonTask.getLoginUserRole().equals("2")) {
            sysRoleService.getUserByRoleCode("centerman", result2);
        } else if (tkCommonTask.getLoginUserRole().equals("3")) {
            sysRoleService.getUserByRoleCode("twogrid", result2);
        } else {//其他登录角色等级为  1级的  也是上报给中心
            sysRoleService.getUserByRoleCode("centerman", result2);
        }

        try {

            if (StringUtils.isNotBlank(tkCommonTask.getRoundMatterId())) {
                //在roundMatter表中存入任务idsss
                TkRoundMatter tkRoundMatter = tkRoundMatterService.selectByPrimaryKey(tkCommonTask.getRoundMatterId());
                tkRoundMatter.setComTaskId(tkCommonTask.getId());
                tkRoundMatter.setAction("3");
                tkRoundMatterService.updateByPrimaryKey(tkRoundMatter);
            }
            if (tkCommonTaskService.saveTask(tkCommonTask, tkCommonReport, bsRcsxbs, result, tkCommonAssigned,result2) == 0) {
                throw new ServiceException("保存出错",400);
            }

        } catch (Exception e) {
            log.error("业务异常",e);
            throw new ServiceException("保存出错",400);
        }

        try {
            //12是区级调度的数据，如果保存成功后，要改变调度表的数据未签收状态。
            Integer comeFrom = tkCommonTask.getComeFrom();
            if (comeFrom != null) {
                if (comeFrom == 12) {
                    if (StringUtils.isNotBlank(tkCommonTask.getDiaoduId())) {
                        TkCommonDiaodu tkCommonDiaodu = tkCommonDiaoduService.selectByPrimaryKey(tkCommonTask.getDiaoduId());
                        tkCommonDiaodu.setDdTkid(tkCommonTask.getId());
                        tkCommonDiaodu.setDdStatus("1");//已签收
                        tkCommonDiaoduService.updateByPrimaryKey(tkCommonDiaodu);
                    }
                }
            }

        } catch (Exception e) {
            log.error("业务异常",e);
        }
        return uuid;
    }

    @Override
    @Transactional
    public void addNew(TkCommonTask tkCommonTask) {
        TkCommonTask tkTaskModel = tkCommonTaskService.selectByPrimaryKey(tkCommonTask.getId());
        if (tkTaskModel != null) {
            throw new ServiceException("数据已存在",400);
        }
        tkCommonTask.setWgCode("wgCode");
        tkCommonTask.setReleaseUserId("b34e3c4c-964d-47b6-9e49-394c9671682d");
        tkCommonTask.setReleaseUserName("戴文章");
        tkCommonTask.setLoginUserGrid("塔集镇");
        tkCommonTask.setLoginUserRole("1");
        tkCommonTask.setCreateBy("戴文章");
        tkCommonTask.setComeFrom(1);
        tkCommonTask.setBelongGrid("陆河村委会网格一");
        tkCommonTask.setStandby1("1");
        tkCommonTask.setMatterType(1);
        tkCommonTask.setStandby5("1");
        tkCommonTask.setHandleType(3);

        tkCommonTask.setReleaseUserRoleNum(Integer.parseInt(tkCommonTask.getLoginUserRole()));
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String releaseTime = sdf.format(tkCommonTask.getReleaseTime());
            tkCommonTask.setReleaseTime(sdf.parse(releaseTime));
        } catch (Exception e) {
            log.error("业务异常",e);
        }
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String dateNowStr = sdf.format(d);
        System.out.println("格式化后的日期：" + dateNowStr);
        tkCommonTask.setTkId(dateNowStr.substring(0, 15));
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd:HH:mm:ss");
        String now = sdf2.format(new Date());
        try {
            tkCommonTask.setCreateTime(sdf2.parse(now));
        } catch (Exception e) {
            log.error("业务异常",e);
        }
        //获取父网格id和name
        setWgCodeAndWgName(tkCommonTask);
        setMatterIdAndMatterName(tkCommonTask);
        //获取父网格id和name

        //创建上报实体类
        TkCommonReport tkCommonReport = new TkCommonReport();
        tkCommonReport.setId(UUID.randomUUID().toString());
        tkCommonReport.setCommonTkId(tkCommonTask.getId());
        tkCommonReport.setCreateTime(new Date());
        String roleCode = "";//


        SimpleDateFormat sdf3 = new SimpleDateFormat("yyyy-MM-dd");
        Date assignedEndTime = null;
        try {
            String format = sdf3.format(new Date());
            assignedEndTime = sdf3.parse(format);
        } catch (Exception e) {
            log.error("业务异常",e);
        }
        //创建指派实体类 如果是自行处理就得保存  自己指派给自己
        TkCommonAssigned tkCommonAssigned = null;

        if (tkCommonTask.getHandleType() == 0) {//0自行处理-1上报上级-2上报中心-3指派下级
            tkCommonTask.setTkStatus(20);//任务处理状态是20
            tkCommonTask.setAssignedEndTime(assignedEndTime);//处理完成时间

            tkCommonAssigned = new TkCommonAssigned();//任务指派实体类
            tkCommonAssigned.setId(UUID.randomUUID().toString());
            tkCommonAssigned.setCommonTkId(tkCommonTask.getId());
            tkCommonAssigned.setAssignedUserId(tkCommonTask.getReleaseUserId());//指派人id
            tkCommonAssigned.setAssignedUserName(tkCommonTask.getReleaseUserName());//指派人姓名
            tkCommonAssigned.setAssignedEndTime(new Date());
            tkCommonAssigned.setAssignedRole(Integer.parseInt(tkCommonTask.getLoginUserRole()));//指派人角色等级
            tkCommonAssigned.setBeassignedUserId(tkCommonTask.getReleaseUserId());//被指派人用户id
            tkCommonAssigned.setBeassignedUserName(tkCommonTask.getReleaseUserName());//被指派人用户名
            tkCommonAssigned.setBeassignedRole(Integer.parseInt(tkCommonTask.getLoginUserRole()));//被指派人角色等级
            tkCommonAssigned.setAssignedStatus(1);//没数据就设为 1

            //任务上报到哪一级。3三级 2二级 1一级 0中心
        } else if (tkCommonTask.getHandleType() == 1) {//上报上级
            tkCommonTask.setTkStatus(10);
            if (tkCommonTask.getLoginUserRole().equals("2")) {
                tkCommonTask.setStandby2("0");
                tkCommonReport.setTolevel("0");
                roleCode = "centerman";
            } else {
                if (tkCommonTask.getLoginUserRole().equals("1")) {//中心
                    tkCommonTask.setStandby2("0");
                    tkCommonReport.setTolevel("0");
                    roleCode = "centerman";
                } else if (tkCommonTask.getLoginUserRole().equals("3")) {//2级
                    tkCommonTask.setStandby2("2");
                    tkCommonReport.setTolevel("2");
                    //roleCode="twogrid";  只要中心才自动指派
                }
            }

        } else if (tkCommonTask.getHandleType() == 2) {//上报中心
            tkCommonTask.setTkStatus(10);
            tkCommonTask.setStandby2("0");
            tkCommonReport.setTolevel("0");
            roleCode = "centerman";
        } else if (tkCommonTask.getHandleType() == 3) {//指派下级
            tkCommonTask.setTkStatus(10);
        }

        String now2 = sdf2.format(new Date());
        try {
            tkCommonAssigned.setCreateTime(sdf2.parse(now2));
        } catch (Exception e) {
            //log.error("业务异常",e);
        }
        tkCommonTask.setStandby1("0");
        tkCommonTask.setCreateBy(tkCommonTask.getReleaseUserId());

        //自动指派逻辑
        List<GridItemDaily> bsRcsxbs = new ArrayList<GridItemDaily>();//自行指派的数据
        AjaxResult result = new AjaxResult();//根据角色获取用户们
        //查找管理员
        if ((tkCommonTask.getHandleType() != 0 || tkCommonTask.getHandleType() != 3) && !roleCode.equals("")) {//不为自行处理 或者不为指派下级
            //（网格分类：城乡综合网格cx、企业网格qy、资产网格zc  其他qt
            GridItemDailyExample example = new GridItemDailyExample();
            GridItemDailyExample.Criteria criteria1 = example.createCriteria();
            criteria1.andIsValidEqualTo("1");
            criteria1.andIdEqualTo(tkCommonTask.getMatterId());
            bsRcsxbs = bsRcsxbService.selectByExample(example);//指派的数据
            sysRoleService.getUserByRoleCode(roleCode, result);
            //-----------------------网格代码

        }

        //数据 上报上级的接收人数据 所以当前登录角色为2级 就查询中心的用户。
        AjaxResult result2 = new AjaxResult();//根据角色获取用户们
        if (tkCommonTask.getLoginUserRole().equals("2")) {
            sysRoleService.getUserByRoleCode("centerman", result2);
        } else if (tkCommonTask.getLoginUserRole().equals("3")) {
            sysRoleService.getUserByRoleCode("twogrid", result2);
        } else {//其他登录角色等级为  1级的  也是上报给中心
            sysRoleService.getUserByRoleCode("centerman", result2);
        }

        try {
            if (tkCommonTaskService.saveTask(tkCommonTask, tkCommonReport, bsRcsxbs, result, tkCommonAssigned,result2) == 0) {
                throw new ServiceException("保存出错",400);
            }
        } catch (Exception e) {
            log.error("业务异常",e);
            throw new ServiceException("保存出错",400);
        }
    }

    @Transactional
    @Override
    public void resetQpr(TkResetRequest request) {
        if (StringUtils.isAnyBlank(request.getId(),request.getQprIds())){
            throw new ServiceException("参数错误",400);
        }
        TkCommonTask task = tkCommonTaskService.selectByPrimaryKey(request.getId());
        task.setQprIds(request.getQprIds());
        task.setQprId(null);
        task.setQprName(null);
        //删除指派之后的步骤
        this.resetAfterAssigned(task);
        //日志
        TkCommonTaskDynamic tkCommonTaskDynamic = new TkCommonTaskDynamic();
        tkCommonTaskDynamic.setId(UUID.randomUUID().toString());
        tkCommonTaskDynamic.setCommonTkId(task.getId());
        tkCommonTaskDynamic.setName(request.getLoginUserName());//当前登录人
        tkCommonTaskDynamic.setAddress(request.getLoginUserBelongGrid());
        List<SysUser> users = userService.listByIds(Arrays.asList(request.getQprIds().split(",")));
        tkCommonTaskDynamic.setNote("重新指派了签批人为："+users.stream().map(SysUser::getNickName).collect(Collectors.joining(",")));
        tkCommonTaskDynamic.setTkTime(task.getCreateTime());
        tkCommonTaskDynamic.setCreateTime(new Date());
        tkCommonTaskDynamicService.insert(tkCommonTaskDynamic);
    }

    @Transactional
    @Override
    public void resetAfterAssigned(TkCommonTask task){
        task.setTkStatus(10);
        task.setAssignedDeptIds(null);
        task.setAssignedDeptNames(null);
        task.setAssignedUserId(null);
        task.setAssignedUserName(null);
        task.setPerformUserId(null);
        task.setPerformUserName(null);
        task.setPerformPicture(null);
        task.setPerformNode(null);
        task.setAssignedEndTime(null);
        task.setAssignedTime(null);
        task.setAssignedNode(null);
        task.setZpVerificationUserId(null);
        task.setZpVerificationUserName(null);
        task.setVerificationUserId(null);
        task.setVerificationUserName(null);
        task.setVerificationEndTime(null);
        task.setVerificationTime(null);
        task.setVerificationNode(null);
        task.setVerificationStatus(null);
        task.setTkScore(null);
        task.setEndNode(null);
        task.setEndTime(null);
        task.setStandby4(null);
        task.setPjPersonId(null);
        task.setPjPersonName(null);
        tkCommonTaskService.updateByPrimaryKey(task);
        //删除 指派人
        tkCommonAssignedService.deleteByTaskId(task.getId());
        //删除转督办
        tkCommonLeaderService.deleteByTaskId(task.getId());
        //删除领导签批
        tkCommonQianpiService.deleteByTaskId(task.getId());
        //删除接收人
        tkCommonReceiveService.deleteByTaskId(task.getId());
    }

    @Transactional
    @Override
    public void dealBihuan() {
        TkCommonTaskExample example = new TkCommonTaskExample();
        example.createCriteria().andTkStatusEqualTo(40).andVerificationEndTimeLessThan(
                DateUtils.addDays(new Date(),-3)
        );
        List<TkCommonTask> tasks = tkCommonTaskService.selectByExample(example);
        if (CollectionUtils.isEmpty(tasks)){
            return;
        }
        for (TkCommonTask tkCommonTask : tasks) {
            tkCommonTask.setTkStatus(50);//结束状态
            tkCommonTask.setEndTime(new Date());//评价时间
            tkCommonTaskService.updateByPrimaryKey(tkCommonTask);
        }
    }


    private void setWgCodeAndWgName(@RequestBody TkCommonTask tkCommonTask) {
        try {
            String wgCode = tkCommonTask.getWgCode();
            if (StringUtils.isBlank(wgCode)){
                return;
            }
            GridRegionExample bsWgxxbExample = new GridRegionExample();
            GridRegionExample.Criteria criteria = bsWgxxbExample.createCriteria();
            criteria.andWgCodeEqualTo(wgCode);
            List<GridRegion> bsWgxxbs = bsWgxxbService.selectByExample(bsWgxxbExample);
            if (bsWgxxbs.size() == 0) {
                return;
            }
            tkCommonTask.setBelongGrid(bsWgxxbs.get(0).getWgName());
            String wgParentId = bsWgxxbs.get(0).getWgParentId();
            if (wgParentId != null && wgParentId.equals("320282105")) {//二级网格
                //塞入父id为bsWgxxbs.get(0).getWgCode()
                tkCommonTask.setWgParentId(bsWgxxbs.get(0).getWgCode());
                //塞入父name为bsWgxxbs.get(0).getWgName()
                tkCommonTask.setWgParentName(bsWgxxbs.get(0).getWgName());
            } else {//三级网格
                if (wgParentId == null) {//徐舍镇
                    tkCommonTask.setWgParentId(bsWgxxbs.get(0).getWgCode());
                    tkCommonTask.setWgParentName(bsWgxxbs.get(0).getWgName());
                } else {
                    //塞入父id为wgParentId
                    tkCommonTask.setWgParentId(wgParentId);
                    //查询网格code为上一行的wgParentId 取出数据中的网格name塞入
                    GridRegionExample bsWgxxbExample2 = new GridRegionExample();
                    GridRegionExample.Criteria criteria1 = bsWgxxbExample2.createCriteria();
                    criteria1.andWgCodeEqualTo(wgParentId);
                    List<GridRegion> bsWgxxbs1 = bsWgxxbService.selectByExample(bsWgxxbExample2);
                    tkCommonTask.setWgParentName(bsWgxxbs1.get(0).getWgName());
                }

            }

        } catch (Exception e) {
            log.error("业务异常",e);
        }
    }

    //bsRcsxbService
    private void setMatterIdAndMatterName(@RequestBody TkCommonTask tkCommonTask) {
        String matterId = tkCommonTask.getMatterId();

        GridItemDaily bsRcsxb = bsRcsxbService.selectByPrimaryKey(matterId);
        String matterParentId = bsRcsxb.getSjfl();
        tkCommonTask.setParentMattetrId(matterParentId);

        GridItemDailyExample bsRcsxbExample = new GridItemDailyExample();
        GridItemDailyExample.Criteria criteria = bsRcsxbExample.createCriteria();
        criteria.andSxbmEqualTo(matterParentId);
        List<GridItemDaily> bsRcsxbs = bsRcsxbService.selectByExample(bsRcsxbExample);
        tkCommonTask.setParentMattetrName(bsRcsxbs.get(0).getSxmc());
    }
}
