package com.ruoyi.system.domain.zb.enums;

/**
 * * Author: brenda
 * * 2025/1/10
 **/
public enum WeekReportTypeEnum {

    AUTO("AUTO","自动发布"),

    MANUAL("MANUAL","手动发布");

    private String code;

    private String value;

    private WeekReportTypeEnum(String code, String value) {
        this.code = code;
        this.value = value;
    }

    public static WeekReportTypeEnum getByCode(String code) {
        if (code == null || code.trim().length() <= 0) {
            return null;
        }
        for (int i = 0; i < values().length; i++) {
            if (values()[i].code.equals(code)) {
                return values()[i];
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }
}
