package com.ruoyi.system.domain.stamp.enums;


/**
 * * Author: brenda
 * * 2025/1/22
 **/
public enum ExamineStatusEnum {
    PROCESSING("P","待审批"),

    FINISHED("F","审批通过"),

    BACK("B","已退回");

    private String code;

    private String value;

    private ExamineStatusEnum(String code, String value) {
        this.code = code;
        this.value = value;
    }

    public static ExamineStatusEnum getByCode(String code) {
        if (code == null || code.trim().length() <= 0) {
            return null;
        }
        for (int i = 0; i < values().length; i++) {
            if (values()[i].code.equals(code)) {
                return values()[i];
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }
}
