package com.ruoyi.party.mapper;

import com.ruoyi.party.domain.PartyMemberError;

import java.util.List;

/**
 * 党员Mapper接口
 * 
 * @author ruoyi
 * @date 2024-05-21
 */
public interface PartyMemberErrorMapper 
{
    /**
     * 查询党员
     * 
     * @param id 党员主键
     * @return 党员
     */
    public PartyMemberError selectPartyMemberErrorById(Long id);

    /**
     * 查询党员列表
     * 
     * @param partyMemberError 党员
     * @return 党员集合
     */
    public List<PartyMemberError> selectPartyMemberErrorList(PartyMemberError partyMemberError);

    /**
     * 新增党员
     * 
     * @param partyMemberError 党员
     * @return 结果
     */
    public int insertPartyMemberError(PartyMemberError partyMemberError);

    /**
     * 修改党员
     * 
     * @param partyMemberError 党员
     * @return 结果
     */
    public int updatePartyMemberError(PartyMemberError partyMemberError);

    /**
     * 删除党员
     * 
     * @param id 党员主键
     * @return 结果
     */
    public int deletePartyMemberErrorById(Long id);

    /**
     * 批量删除党员
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deletePartyMemberErrorByIds(Long[] ids);
}
