/**
 * 
 */
package com.ruoyi.common.core.redis;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

/**
 * 基于redis的验证码存取器，避免由于没有session导致无法存取验证码的问题
 * 
 * @author zhailiang
 *
 */
@Component
public class RedisRepository {

	@Autowired
	private RedisTemplate<Object, Object> redisTemplate;
	
	public void save(String key,String value) {
		
		redisTemplate.opsForValue().set(key, value);//30->5
	}

	public void save(String key,String value,long l) {

		redisTemplate.opsForValue().set(key, value,l,TimeUnit.SECONDS);//30->5
	}

	public String get(String key) {
		return (String) redisTemplate.opsForValue().get(key);//30->5
	}

	public void delete(String key){
		redisTemplate.delete(key);
	}
}
