package com.ruoyi.common.utils;

import com.ruoyi.common.config.BsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * @Author wujm
 * @CreateTime 2020/6/11
 * @Note
 **/
public class BsUtils {
    private static final Logger logger= LoggerFactory.getLogger(BsUtils.class);
    /** 发送格式 */
    private static final String contentTypeJSON="application/json;charset-utf-8";

    private BsUtils() {
    }

    /**
     * json请求头
     * @param
     * @return
     */
    public static Map<String,Object> jsonHeader() {
        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type",contentTypeJSON);
        return headers;
    }
    /**
     * 业务请求时json请求头，带token
     * @param token
     * @return
     */
    public static Map<String,Object> bsJsonHeader(String token) {
        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type", contentTypeJSON);
        headers.put("Authorization", "Bearer " + token);
        return headers;
    }
    /**
     * 业务请求时get请求头，带token
     * @param token
     * @return
     */
    public static Map<String,Object> bsGetHeader(String token) {
        Map<String, Object> headers = new HashMap<>();
        headers.put("Authorization", "Bearer " + token);
        return headers;
    }

    /**
     * 业务请求时json请求头，带token
     * @param token
     * @return
     */
    public static Map<String,Object> bsJsonHeader(String token,String params) {
        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type", contentTypeJSON);
        headers.put("Authorization", params+" " + token);
        return headers;
    }
    /**
     * 业务请求时get请求头，带token
     * @param token
     * @return
     */
    public static Map<String,Object> bsGetHeader(String token,String params) {
        Map<String, Object> headers = new HashMap<>();
        headers.put("Authorization", params+" " + token);
        return headers;
    }

    public  static String getBsCacheKey(String cacheKey) {
        String key = BsConfig.getPrefix()+":"+cacheKey;
        logger.debug("拼接Key：{}",key);
        return  key;
    }
    /**
     * 公共缓存Key，所有应用通用,如微信的缓存accessToken
     * application:weixin:accessToken:appId
     * @param appKey
     * @param appId
     * @return
     */
    public static String getBsCacheKey(String appKey,String appId) {
        String key = String.format("%s:%s:%s","application",appKey,appId);
        logger.debug("拼接Key：{}",key);
        return  key;
    }
    public static String getCacheKey(String cacheKey,String type,String clientId) {
        String key = BsConfig.getPrefix()+":"+cacheKey +type+":"+clientId;
        logger.debug("拼接Key：{}",key);
        return  key;
    }

    /**
     * 不够位数的在前面补0，保留num的长度位数字
     * @param code
     * @return
     */
    public static String formatMindNo(Long code, int num) {
        // 保留num的位数
        // 0 代表前面补充0
        // num 代表长度为4
        // d 代表参数为正数型
        return String.format("%0" + num + "d", code);
    }

    public static String encodingFilenamePDF(String filename) {
        filename = UUID.randomUUID().toString() + "_" + filename + ".pdf";
        return filename;
    }

    public static String encodingFilenameXLS(String filename) {
        filename = UUID.randomUUID().toString() + "_" + filename + ".xlsx";
        return filename;
    }

}
