package com.ruoyi.common.constant;

import java.math.BigDecimal;

/**
 * @author wujm(wujiming @ eszytec.com)
 * @Date 2020/6/13 0013
 * @note
 **/
public class BsConstants {

    /** token 的 redis 缓存前缀 */
    public static final String CACHE_CLIENT_KEY = "bs:token:clientId:";

    /** user信息缓存key */
    public static final String CACHE_KEY_USERINFO = "bs:userinfo:";

    /** user部门信息缓存key */
    public static final String CACHE_KEY_USERDEPART = "bs:userinfo:depart:";

    /** 报修单工单缓存 */
    public static final String CACHE_KEY_MINDNO = "bs:token:mindno:";


    /** token 的 redis 缓存前缀 */
    public static final String CACHE_BASE_KEY = "bs:token:baseId:";

    /** token 的 用户 缓存前缀 */
    public static final String CACHE_USER_KEY = "bs:token:userToken:";

    /** 三方公司分类列表*/
    public static final String CACHE_KEY_THIRDCOMPANY_TYPES = "bs:third:three:types:";

    /**三方公司预算费用*/
    public static final String CACHE_KEY_THIRDCOMPANY_REPAIR_AMOUNT_BUDGET="bs:third:three:repair:amount:budget:";
    /** 三方公司工单数 */
    public static final String CACHE_KEY_THIRDCOMPANY_REPAIR_CNT="bs:third:three:repair:cnt:";
    /** 三方公司实际费用 */
    public static final String CACHE_KEY_THIRDCOMPANY_REPAIR_ACTUAL="bs:third:three:repair:amount:actual:";

    /** 维修公司报价 */
    public static final String CACHE_KEY_THIRDCOMPANY_REPAIR_AMOUNT_REPAIRBUDGET="bs:third:three:repair:amount:repairBudget:";

    /** 三方公司综合得分订单列表 */
    public static final String CACHE_KEY_THIRDCOMPANY_REPAIR_SCORE="bs:third:three:repair:score:";

    /** 部件维修次数(所有) */
    public static final String CACHE_KEY_PART_REPAIR_ALLCNT="bs:part:repair:allcnt:";
    /** 部件维修历史(当前) */
    public static final String CACHE_KEY_PART_REPAIR_CURRENT="bs:part:repair:current:";
    //结算单号
    public static final String CACHE_KEY_STATEMENT_NO="bs:statement:statementNo:";
    //报修单号
    public static final String CACHE_KEY_MIND_NO="bs:mind:mindNO:";

    //我发现
    public static final String CACHE_KEY_IFIND_NO="bs:publicService:iFoundNO:";

    //我发声
    public static final String CACHE_KEY_ISOUND_NO="bs:publicService:iSoundNO:";

    //需求
    public static final String CACHE_KEY_DEMAND_NO="bs:publicService:demandNo:";

    //资源
    public static final String CACHE_KEY_RESOURCE_NO="bs:publicService:resourceNo:";

    //导入
    public static final String CACHE_KEY_IMPORT_NO="bs:bswgxxb:importNo:";

    /**企业详情*/
    public static final String CACHE_KEY_COMPANY_INFO = "bs:company:info:";
    /** token 的 redis 缓存前缀 */
    public static final int CACHE_DURATION = 86400*7;

    /** 进程延时时间，避免主进程事务未结束 */
    public static final int DELAY_TIME=4*1000;

    /** 数据缓存周期(天)*/
    public static final int CACHE_DATA_DURATION_3 = 3;


    /** 远程获取出错 */
    public static final String GET_REMOTE_DATA_ERROR = "获取中央数据失败";

    /**初始密码 */
    public static final String SYSTEM_PASSWORD_APPEND = "123456";

    /** 元转化为分的进制转换 */
    public static final BigDecimal DIV = new BigDecimal("100");

    public static final String ERROR_TOKEN_EXPIRE = "登录过期,请重新登录";

    public static final String ERROR_QUERY_NOT_FOUND = "未查询到数据";


    /**
     * 小程序路径(未登录时用于判断来源)
     */
    public static final String REQUEST_SOURCE_MINIAPP = "/miniapi/";


    //审批动作
    public enum audit {
        draft("草稿"),
        transfer("转交"),
        assign("指派"),
        tongguo("审核通过"),
        tuihui("退回"),
        invalid("终止"),
        reback("撤回");

        private String name;

        private audit(String name)
        {
            this.name = name;
        }
        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}
