package com.ruoyi.web.controller.party;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.party.domain.PartyBuildingNews;
import com.ruoyi.party.domain.vo.PartyBuildingNewsVO;
import com.ruoyi.party.service.api.IPartyBuildingNewsService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 党建要闻Controller
 * 
 * @author ruoyi
 * @date 2024-05-24
 */
@Api(tags = "党建-党建要闻")
@RestController
@RequestMapping("/api/party/partyBuildNews")
public class PartyBuildingNewsController extends BaseController
{
    @Autowired
    private IPartyBuildingNewsService partyBuildingNewsService;

    /**
     * 查询党建要闻列表
     */

    @GetMapping("/list")
    public TableDataInfo list(PartyBuildingNewsVO partyBuildingNews)
    {
        startPage();
        List<PartyBuildingNews> list = partyBuildingNewsService.selectPartyBuildingNewsList(partyBuildingNews);
        return getDataTable(list);
    }

    /**
     * 导出党建要闻列表
     */

    @Log(title = "党建要闻", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, PartyBuildingNewsVO partyBuildingNews)
    {
        List<PartyBuildingNews> list = partyBuildingNewsService.selectPartyBuildingNewsList(partyBuildingNews);
        ExcelUtil<PartyBuildingNews> util = new ExcelUtil<PartyBuildingNews>(PartyBuildingNews.class);
        util.exportExcel(response, list, "党建要闻数据");
    }

    /**
     * 获取党建要闻详细信息
     */

    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(partyBuildingNewsService.selectPartyBuildingNewsById(id));
    }

    /**
     * 新增党建要闻
     */

    @Log(title = "党建要闻", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody PartyBuildingNews partyBuildingNews)
    {
        return toAjax(partyBuildingNewsService.insertPartyBuildingNews(partyBuildingNews));
    }

    /**
     * 修改党建要闻
     */

    @Log(title = "党建要闻", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody PartyBuildingNews partyBuildingNews)
    {
        return toAjax(partyBuildingNewsService.updatePartyBuildingNews(partyBuildingNews));
    }

    /**
     * 删除党建要闻
     */

    @Log(title = "党建要闻", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(partyBuildingNewsService.deletePartyBuildingNewsByIds(ids));
    }
}
