package com.ruoyi.web.controller.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.vo.GridCompanySafeCheckExt;
import com.ruoyi.system.domain.grid.vo.GridCompanySafeCheckParam;
import com.ruoyi.system.service.grid.GridCompanySafeCheckService;
import io.swagger.annotations.Api;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 企业安监检查
 */
@Api(tags = "综合执法-企业检查")
@RestController
@RequestMapping("/api/company/safeCheck")
public class GridCompanySafeCheckController {

    @Autowired
    GridCompanySafeCheckService wsCompanySafeCheckService;

    /**
     * 分页查询安监检查列表
     */
    @GetMapping(value = "/page")
    public AjaxResult page(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                           @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                           @RequestParam(name = "wgCode", required = false) String wgCode,
                           @RequestParam(name = "companyId", required = false) String companyId,
                           @RequestParam(name = "companyName", required = false) String companyName,
                           @RequestParam(name = "companyType", required = false) String companyType,
                           @RequestParam(name = "checkUserId", required = false)String checkUserId,
                           @RequestParam(name = "creditCode", required = false)String creditCode,
                           @RequestParam(name = "checkStatus", required = false)String checkStatus,
                           @RequestParam(name = "startTime", required = false) String startTime,
                           @RequestParam(name = "endTime", required = false) String endTime,
                           @RequestParam(name = "checkType", required = false) String checkType) {
        GridCompanySafeCheckParam param = new GridCompanySafeCheckParam();
        param.setWgCode(wgCode);
        param.setCompanyName(companyName);
        param.setCompanyType(companyType);
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        param.setCompanyId(companyId);
        param.setCheckUserId(checkUserId);
        param.setCreditCode(creditCode);
        param.setCheckStatus(checkStatus);
        param.setCheckType(checkType);
        return AjaxResult.success(wsCompanySafeCheckService.pageInfos(param, pageNo, pageSize));
    }

    /**
     * 保存
     */
    @PostMapping(value = "/add")
    public AjaxResult add(@RequestBody GridCompanySafeCheckExt checkExt) {
        wsCompanySafeCheckService.save(checkExt);
        return AjaxResult.success("提交成功");
    }

    /**
     * 保存
     */
    @PostMapping(value = "/update")
    public AjaxResult update(@RequestBody GridCompanySafeCheckExt checkExt) {
        wsCompanySafeCheckService.update(checkExt);
        return AjaxResult.success("提交成功");
    }

    /**
     * 详情
     */
    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") String id) {
        return AjaxResult.success(wsCompanySafeCheckService.detail(id));
    }

    /**
     * 删除
     */
    @GetMapping(value = "/delete/{id}")
    public AjaxResult delete(@PathVariable("id") String id) {
        wsCompanySafeCheckService.delete(id);
        return AjaxResult.success("删除成功");
    }

    /**
     * 企业近30天检查数量
     */
    @GetMapping(value = "/countThirtyNum")
    public AjaxResult countThirtyNum(@RequestParam(name = "companyId") String companyId) {
        if (StringUtils.isBlank(companyId)) {
            throw new RuntimeException("查询失败：企业id不能为空");
        }
        return AjaxResult.success(wsCompanySafeCheckService.countThirthNum(companyId));
    }

    /**
     * 大屏：安监检查统计信息
     */
    @GetMapping(value = "/countSafeCheck")
    public AjaxResult countSafeCheck(@RequestParam(name = "wgCode") String wgCode) {
        return AjaxResult.success(wsCompanySafeCheckService.countSafeCheckInfo(wgCode));
    }

    /**
     * 大屏：安监检查企业检查情况
     */
    @GetMapping(value = "/countCompanyCheckInfo")
    public AjaxResult countCompanyCheckInfo(@RequestParam(name = "wgCode") String wgCode) {
        return AjaxResult.success(wsCompanySafeCheckService.countCompanyCheckInfo(wgCode));
    }

    /**
     * 大屏：安监检查村级检查企业数
     */
    @GetMapping(value = "/countCountryCheckInfo")
    public AjaxResult countCountryCheckInfo(@RequestParam(name = "wgCode") String wgCode) {
        return AjaxResult.success(wsCompanySafeCheckService.countCountryCheckInfo(wgCode));
    }

    /**
     * 大屏：安监检查村级检查企业数
     */
    @GetMapping(value = "/countSevenDayCheckInfo")
    public AjaxResult countSevenDayCheckInfo(@RequestParam(name = "wgCode") String wgCode) {
        return AjaxResult.success(wsCompanySafeCheckService.countSevenDayCheckInfo(wgCode));
    }

    /**
     * 大屏：分页查询安监检查列表
     */
    @GetMapping(value = "/count/pageInfo")
    public AjaxResult countPageInfo(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                  @RequestParam(name = "pageSize", defaultValue = "15") Integer pageSize,
                                  @RequestParam(name = "wgCode", required = false) String wgCode,
                                  @RequestParam(name = "searchName", required = false) String searchName,
                                  @RequestParam(name = "startTime", required = false) String startTime,
                                  @RequestParam(name = "endTime", required = false) String endTime) {
        GridCompanySafeCheckParam param = new GridCompanySafeCheckParam();
        param.setWgId(wgCode);
        param.setSearchName(searchName);
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        return AjaxResult.success(wsCompanySafeCheckService.countPageInfo(param, pageNo, pageSize));
    }

    /**
     * 大屏：分页查询定点安监检查列表
     */
    @GetMapping(value = "/count/pointPageInfo")
    public AjaxResult countPageInfo(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                      @RequestParam(name = "pageSize", defaultValue = "15") Integer pageSize,
                                      @RequestParam(name = "longitude", required = false) String longitude,
                                      @RequestParam(name = "latitude", required = false) String latitude) {
        GridCompanySafeCheckParam param = new GridCompanySafeCheckParam();
        param.setClockLongitude(longitude);
        param.setClockLatitude(latitude);
        return AjaxResult.success(wsCompanySafeCheckService.countPointPageInfo(param, pageNo, pageSize));
    }
}
