package com.ruoyi.web.controller.party;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.party.domain.ExcellentParty;
import com.ruoyi.party.service.api.IExcellentPartyService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 优秀党组织Controller
 * 
 * @author ruoyi
 * @date 2024-05-20
 */
@Api(tags = "党建-优秀党组织")
@RestController
@RequestMapping("/api/party/excellentParty")
public class ExcellentPartyController extends BaseController
{
    @Autowired
    private IExcellentPartyService excellentPartyService;

    /**
     * 查询优秀党组织列表
     */
    @GetMapping("/list")
    public TableDataInfo list(ExcellentParty excellentParty)
    {
        startPage();
        List<ExcellentParty> list = excellentPartyService.selectExcellentPartyList(excellentParty);
        TableDataInfo tableDataInfo = getDataTable(list);
        if(!CollectionUtils.isEmpty(tableDataInfo.getRows())){
            tableDataInfo.setRows(excellentPartyService.convertData((List<ExcellentParty>) tableDataInfo.getRows()));
        }
        return tableDataInfo;
    }

    /**
     * 导出优秀党组织列表
     */
    @Log(title = "优秀党组织", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ExcellentParty excellentParty)
    {
        List<ExcellentParty> list = excellentPartyService.selectExcellentPartyList(excellentParty);
        ExcelUtil<ExcellentParty> util = new ExcelUtil<ExcellentParty>(ExcellentParty.class);
        util.exportExcel(response, list, "优秀党组织数据");
    }

    /**
     * 获取优秀党组织详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return success(excellentPartyService.selectExcellentPartyById(id));
    }

    /**
     * 新增优秀党组织
     */
    @Log(title = "优秀党组织", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ExcellentParty excellentParty)
    {
        return toAjax(excellentPartyService.insertExcellentParty(excellentParty));
    }

    /**
     * 修改优秀党组织
     */
    @Log(title = "优秀党组织", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ExcellentParty excellentParty)
    {
        return toAjax(excellentPartyService.updateExcellentParty(excellentParty));
    }

    /**
     * 删除优秀党组织
     */
    @Log(title = "优秀党组织", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(excellentPartyService.deleteExcellentPartyByIds(ids));
    }



   //获取优秀党组织beginDate:有效日期
    @RequestMapping(value="getGoodPartyOrgCounts",method = RequestMethod.GET)
    @ResponseBody
    public AjaxResult getGoodPartyOrgCounts(Integer year,String beginDate){

        String goodPartyOrgCountspartyCounts=excellentPartyService.getGoodPartyOrgCounts(year,beginDate);
        return success(goodPartyOrgCountspartyCounts);
    }

}
