package com.ruoyi.web.controller.grid;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridPublicOpinions;
import com.ruoyi.system.service.grid.GridPublicOpinionsService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author : peter
 * @description: 社情民意
 * @date : 2022-06-01 13:37
 */
@Api(tags = "人口信息-社情民意")
@RestController
@RequestMapping("/api/grid/publicOpinions")
public class PublicOpinionsController {

    @Autowired
    private GridPublicOpinionsService GridPublicOpinionsService;

    /**
     * 社情民意列表
     */
    @GetMapping(value = "/page")
    public AjaxResult interviewPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                    @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                    @RequestParam(value = "peopleId") String peopleId) {
        try {
            PageHelper.startPage(pageNum, pageSize);
            PageInfo<GridPublicOpinions> pageInfo = new PageInfo<>(GridPublicOpinionsService.page(peopleId));
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

    /**
     * 社情民意新增
     */
    @PostMapping(value = "/add")
    public AjaxResult add(@RequestBody GridPublicOpinions GridPublicOpinions) {
        return AjaxResult.success(GridPublicOpinionsService.add(GridPublicOpinions));
    }

    /**
     * 社情民意编辑
     */
    @PostMapping(value = "/edit")
    public AjaxResult edit(@RequestBody GridPublicOpinions GridPublicOpinions) {
        GridPublicOpinionsService.edit(GridPublicOpinions);
        return AjaxResult.success();
    }

    /**
     * 社情民意详情
     */
    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") String id) {
        return AjaxResult.success(GridPublicOpinionsService.detail(id));
    }

    /**
     * 社情民意删除
     */
    @GetMapping(value = "/delete")
    public AjaxResult delete(@RequestParam(value = "ids") String ids) {
        GridPublicOpinionsService.delete(ids);
        return AjaxResult.success();
    }

}
