package com.ruoyi.web.controller.form;

import com.ruoyi.common.annotation.Anonymous;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.form.MdFormRecord;
import com.ruoyi.system.domain.form.params.FormRecordQuery;
import com.ruoyi.system.service.form.FormManager;
import com.ruoyi.system.service.form.FormRecordManager;
import io.swagger.annotations.Api;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;


/**
 * 表单数据
 */
@Api(tags = "在线表单 - 表单数据")
@RestController
@RequestMapping("/api/form/record")
public class FormRecordController extends BaseController {

    @Autowired
    private FormRecordManager recordManager;

    @PostMapping(value = "/mind")
    @ResponseBody
    public AjaxResult mind(@RequestParam(name = "form_id") String form_id,
                           @RequestParam(name = "noRecord", defaultValue = "0") Integer noRecord) {
        if (StringUtils.isBlank(form_id)) {
            return AjaxResult.build(400, "参数异常", "form_id参数不能为空");
        }
        try {
            //true 代表发送短信
            recordManager.mind(form_id, noRecord, false);
            return AjaxResult.success("成功");
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

    /**
     * 表单标签
     */
    @RequestMapping(value = "/labels", method = RequestMethod.GET)
    @ResponseBody
    public AjaxResult queryLabels(@RequestParam(name = "id") String id) {
        if (StringUtils.isBlank(id)) {
            return AjaxResult.build(400, "参数异常", "id不能为空");
        }
        return AjaxResult.success(recordManager.formLabels(id));
    }

    @GetMapping(value = "/list")
    @ResponseBody
    public AjaxResult list(FormRecordQuery query) {
        if (query == null) {
            return AjaxResult.build(400, "参数异常", "query参数不能为空");
        }

        query.setUserId(getUserId());
        try {
            return AjaxResult.success(recordManager.list(query));
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }


    @GetMapping(value = "/commit/list")
    @ResponseBody
    public AjaxResult commit_list(FormRecordQuery query) {
        if (query == null || StringUtils.isBlank(query.getForm_id())) {
            return AjaxResult.build(400, "参数异常", "query参数不能为空");
        }

        try {
            query.setCommit_status(1);
            return AjaxResult.success(recordManager.queryCommit(query));
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

    @GetMapping(value = "/no/list")
    @ResponseBody
    public AjaxResult no_list(FormRecordQuery query) {
        if (query == null || StringUtils.isBlank(query.getForm_id())) {
            return AjaxResult.build(400, "参数异常", "query参数不能为空");
        }

        try {
            query.setCommit_status(0);
            return AjaxResult.success(recordManager.queryNoCommit(query));
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }


    @Anonymous
    @GetMapping(value = "/export")
    public void export(FormRecordQuery query, HttpServletResponse response) throws IOException {
        if (query == null || StringUtils.isBlank(query.getForm_id())) {
            throw new RuntimeException("参数异常");
        }
        query.setCommit_status(1);
        recordManager.export(response, query);
    }

    @GetMapping(value = "/no/export")
    public void no_export(FormRecordQuery query, HttpServletResponse response) throws IOException {
        if (query == null || StringUtils.isBlank(query.getForm_id())) {
            throw new RuntimeException("参数异常");
        }
        query.setCommit_status(0);
        recordManager.no_export(response, query);
    }


    @PostMapping(value = "/save")
    @ResponseBody
    public AjaxResult save(@RequestBody MdFormRecord body) {

        try {
            return AjaxResult.success("操作成功",recordManager.save(body));
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }


    @GetMapping(value = "/detail")
    @ResponseBody
    public AjaxResult detail(@RequestParam(name = "id") String id) {
        if (StringUtils.isBlank(id)) {
            return AjaxResult.build(400, "参数异常", "id不能为空");
        }
        try {
            return AjaxResult.success(recordManager.detail(id));
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

    /**
     * 删除
     */
    @PostMapping(value = "/delete")
    public AjaxResult delete(@RequestBody List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return AjaxResult.build(400, "参数异常", "id不能为空");
        }
        return AjaxResult.success(recordManager.deleteRecord(ids));
    }


    /**
     * s
     * 导入模版
     */
    @GetMapping(value = "/import/template")
    public void import_template(@RequestParam(name = "formId", required = true) String formId, HttpServletResponse res) throws IOException {
        if (StringUtils.isBlank(formId)) {
            throw new RuntimeException("参数异常");
        }
        recordManager.importTemplate(res, formId);
    }

}

