/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.common;

import com.taobao.arthas.common.OSUtils;
import java.util.logging.Level;
import java.util.regex.Matcher;

public abstract class AnsiLog {
    static boolean enableColor;
    public static Level LEVEL;
    private static final String RESET = "\u001b[0m";
    private static final int DEFAULT = 39;
    private static final int BLACK = 30;
    private static final int RED = 31;
    private static final int GREEN = 32;
    private static final int YELLOW = 33;
    private static final int BLUE = 34;
    private static final int MAGENTA = 35;
    private static final int CYAN = 36;
    private static final int WHITE = 37;
    private static final String TRACE_PREFIX = "[TRACE] ";
    private static final String TRACE_COLOR_PREFIX;
    private static final String DEBUG_PREFIX = "[DEBUG] ";
    private static final String DEBUG_COLOR_PREFIX;
    private static final String INFO_PREFIX = "[INFO] ";
    private static final String INFO_COLOR_PREFIX;
    private static final String WARN_PREFIX = "[WARN] ";
    private static final String WARN_COLOR_PREFIX;
    private static final String ERROR_PREFIX = "[ERROR] ";
    private static final String ERROR_COLOR_PREFIX;

    private AnsiLog() {
    }

    public static boolean enableColor() {
        return enableColor;
    }

    public static Level level(Level level) {
        Level old = LEVEL;
        LEVEL = level;
        return old;
    }

    public static Level level() {
        return LEVEL;
    }

    public static String black(String msg) {
        if (enableColor) {
            return AnsiLog.colorStr(msg, 30);
        }
        return msg;
    }

    public static String red(String msg) {
        if (enableColor) {
            return AnsiLog.colorStr(msg, 31);
        }
        return msg;
    }

    public static String green(String msg) {
        if (enableColor) {
            return AnsiLog.colorStr(msg, 32);
        }
        return msg;
    }

    public static String yellow(String msg) {
        if (enableColor) {
            return AnsiLog.colorStr(msg, 33);
        }
        return msg;
    }

    public static String blue(String msg) {
        if (enableColor) {
            return AnsiLog.colorStr(msg, 34);
        }
        return msg;
    }

    public static String magenta(String msg) {
        if (enableColor) {
            return AnsiLog.colorStr(msg, 35);
        }
        return msg;
    }

    public static String cyan(String msg) {
        if (enableColor) {
            return AnsiLog.colorStr(msg, 36);
        }
        return msg;
    }

    public static String white(String msg) {
        if (enableColor) {
            return AnsiLog.colorStr(msg, 37);
        }
        return msg;
    }

    private static String colorStr(String msg, int colorCode) {
        return "\u001b[" + colorCode + "m" + msg + RESET;
    }

    public static void trace(String msg) {
        if (AnsiLog.canLog(Level.FINEST)) {
            if (enableColor) {
                System.out.println(TRACE_COLOR_PREFIX + msg);
            } else {
                System.out.println(TRACE_PREFIX + msg);
            }
        }
    }

    public static void trace(String format, Object ... arguments) {
        if (AnsiLog.canLog(Level.FINEST)) {
            AnsiLog.trace(AnsiLog.format(format, arguments));
        }
    }

    public static void trace(Throwable t) {
        if (AnsiLog.canLog(Level.FINEST)) {
            t.printStackTrace(System.out);
        }
    }

    public static void debug(String msg) {
        if (AnsiLog.canLog(Level.FINER)) {
            if (enableColor) {
                System.out.println(DEBUG_COLOR_PREFIX + msg);
            } else {
                System.out.println(DEBUG_PREFIX + msg);
            }
        }
    }

    public static void debug(String format, Object ... arguments) {
        if (AnsiLog.canLog(Level.FINER)) {
            AnsiLog.debug(AnsiLog.format(format, arguments));
        }
    }

    public static void debug(Throwable t) {
        if (AnsiLog.canLog(Level.FINER)) {
            t.printStackTrace(System.out);
        }
    }

    public static void info(String msg) {
        if (AnsiLog.canLog(Level.CONFIG)) {
            if (enableColor) {
                System.out.println(INFO_COLOR_PREFIX + msg);
            } else {
                System.out.println(INFO_PREFIX + msg);
            }
        }
    }

    public static void info(String format, Object ... arguments) {
        if (AnsiLog.canLog(Level.CONFIG)) {
            AnsiLog.info(AnsiLog.format(format, arguments));
        }
    }

    public static void info(Throwable t) {
        if (AnsiLog.canLog(Level.CONFIG)) {
            t.printStackTrace(System.out);
        }
    }

    public static void warn(String msg) {
        if (AnsiLog.canLog(Level.WARNING)) {
            if (enableColor) {
                System.out.println(WARN_COLOR_PREFIX + msg);
            } else {
                System.out.println(WARN_PREFIX + msg);
            }
        }
    }

    public static void warn(String format, Object ... arguments) {
        if (AnsiLog.canLog(Level.WARNING)) {
            AnsiLog.warn(AnsiLog.format(format, arguments));
        }
    }

    public static void warn(Throwable t) {
        if (AnsiLog.canLog(Level.WARNING)) {
            t.printStackTrace(System.out);
        }
    }

    public static void error(String msg) {
        if (AnsiLog.canLog(Level.SEVERE)) {
            if (enableColor) {
                System.out.println(ERROR_COLOR_PREFIX + msg);
            } else {
                System.out.println(ERROR_PREFIX + msg);
            }
        }
    }

    public static void error(String format, Object ... arguments) {
        if (AnsiLog.canLog(Level.SEVERE)) {
            AnsiLog.error(AnsiLog.format(format, arguments));
        }
    }

    public static void error(Throwable t) {
        if (AnsiLog.canLog(Level.SEVERE)) {
            t.printStackTrace(System.out);
        }
    }

    private static String format(String from, Object ... arguments) {
        if (from != null) {
            String computed = from;
            if (arguments != null && arguments.length != 0) {
                for (Object argument : arguments) {
                    computed = computed.replaceFirst("\\{\\}", Matcher.quoteReplacement(argument.toString()));
                }
            }
            return computed;
        }
        return null;
    }

    private static boolean canLog(Level level) {
        return level.intValue() >= LEVEL.intValue();
    }

    static {
        LEVEL = Level.CONFIG;
        TRACE_COLOR_PREFIX = "[" + AnsiLog.colorStr("TRACE", 32) + "] ";
        DEBUG_COLOR_PREFIX = "[" + AnsiLog.colorStr("DEBUG", 32) + "] ";
        INFO_COLOR_PREFIX = "[" + AnsiLog.colorStr("INFO", 32) + "] ";
        WARN_COLOR_PREFIX = "[" + AnsiLog.colorStr("WARN", 33) + "] ";
        ERROR_COLOR_PREFIX = "[" + AnsiLog.colorStr("ERROR", 31) + "] ";
        if (System.console() != null) {
            enableColor = true;
            if (OSUtils.isWindows()) {
                enableColor = false;
            }
        }
        if (OSUtils.isCygwinOrMinGW()) {
            enableColor = true;
        }
    }
}

