/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.http.netty;

import com.alibaba.arthas.deps.io.netty.channel.ChannelFuture;
import com.alibaba.arthas.deps.io.netty.channel.ChannelFutureListener;
import com.alibaba.arthas.deps.io.netty.channel.ChannelHandlerContext;
import com.alibaba.arthas.deps.io.netty.channel.SimpleChannelInboundHandler;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.DefaultHttpResponse;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpHeaders;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpResponseStatus;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpVersion;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.LastHttpContent;
import io.termd.core.http.HttpTtyConnection;
import io.termd.core.util.Logging;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public class HttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final String wsUri;
    private final String httpResourcePath;

    public HttpRequestHandler(String wsUri) {
        this(wsUri, "/io/termd/core/http");
    }

    public HttpRequestHandler(String wsUri, String httpResourcePath) {
        this.wsUri = wsUri;
        this.httpResourcePath = httpResourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        if (this.wsUri.equalsIgnoreCase(request.getUri())) {
            ctx.fireChannelRead(request.retain());
        } else {
            if (HttpHeaders.is100ContinueExpected(request)) {
                HttpRequestHandler.send100Continue(ctx);
            }
            DefaultHttpResponse response = new DefaultHttpResponse(request.getProtocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR);
            String path = new URI(request.getUri()).getPath();
            if ("/".equals(path)) {
                path = "/index.html";
            }
            URL res = HttpTtyConnection.class.getResource(this.httpResourcePath + path);
            try {
                if (res != null) {
                    String ext;
                    String contentType;
                    DefaultFullHttpResponse fullResp = new DefaultFullHttpResponse(request.getProtocolVersion(), HttpResponseStatus.OK);
                    InputStream in = res.openStream();
                    byte[] tmp = new byte[256];
                    int l = 0;
                    while (l != -1) {
                        fullResp.content().writeBytes(tmp, 0, l);
                        l = in.read(tmp);
                    }
                    int li = path.lastIndexOf(46);
                    if (li != -1 && li != path.length() - 1 && (contentType = "html".equals(ext = path.substring(li + 1, path.length())) ? "text/html" : ("js".equals(ext) ? "application/javascript" : ("css".equals(ext) ? "text/css" : null))) != null) {
                        fullResp.headers().set("Content-Type", (Object)contentType);
                    }
                    response = fullResp;
                } else {
                    response.setStatus(HttpResponseStatus.NOT_FOUND);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                ctx.write(response);
                ChannelFuture future = ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
                future.addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.writeAndFlush(response);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Logging.logReportedIoError(cause);
        ctx.close();
    }
}

