/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl;

import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.handlers.term.CloseHandlerWrapper;
import com.taobao.arthas.core.shell.handlers.term.DefaultTermStdinHandler;
import com.taobao.arthas.core.shell.handlers.term.EventHandler;
import com.taobao.arthas.core.shell.handlers.term.RequestHandler;
import com.taobao.arthas.core.shell.handlers.term.SizeHandlerWrapper;
import com.taobao.arthas.core.shell.handlers.term.StdinHandlerWrapper;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.shell.term.SignalHandler;
import com.taobao.arthas.core.shell.term.Term;
import com.taobao.arthas.core.shell.term.impl.CompletionHandler;
import com.taobao.arthas.core.shell.term.impl.Helper;
import com.taobao.arthas.core.util.Constants;
import com.taobao.arthas.core.util.FileUtils;
import io.termd.core.function.Consumer;
import io.termd.core.function.Function;
import io.termd.core.readline.Keymap;
import io.termd.core.readline.Readline;
import io.termd.core.tty.TtyConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TermImpl
implements Term {
    private static final List<io.termd.core.readline.Function> readlineFunctions = io.termd.core.util.Helper.loadServices(io.termd.core.readline.Function.class.getClassLoader(), io.termd.core.readline.Function.class);
    private Readline readline;
    private Consumer<int[]> echoHandler;
    private TtyConnection conn;
    private volatile Handler<String> stdinHandler;
    private List<Function<String, String>> stdoutHandlerChain;
    private SignalHandler interruptHandler;
    private SignalHandler suspendHandler;
    private Session session;
    private boolean inReadline;

    public TermImpl(TtyConnection conn) {
        this(Helper.loadKeymap(), conn);
    }

    public TermImpl(Keymap keymap, TtyConnection conn) {
        this.conn = conn;
        this.readline = new Readline(keymap);
        this.readline.setHistory(FileUtils.loadCommandHistory(new File(Constants.CMD_HISTORY_FILE)));
        for (io.termd.core.readline.Function function : readlineFunctions) {
            this.readline.addFunction(function);
        }
        this.echoHandler = new DefaultTermStdinHandler(this);
        conn.setStdinHandler(this.echoHandler);
        conn.setEventHandler(new EventHandler(this));
    }

    @Override
    public Term setSession(Session session) {
        this.session = session;
        return this;
    }

    @Override
    public void readline(String prompt, Handler<String> lineHandler) {
        if (this.conn.getStdinHandler() != this.echoHandler) {
            throw new IllegalStateException();
        }
        if (this.inReadline) {
            throw new IllegalStateException();
        }
        this.inReadline = true;
        this.readline.readline(this.conn, prompt, new RequestHandler(this, lineHandler));
    }

    @Override
    public void readline(String prompt, Handler<String> lineHandler, Handler<Completion> completionHandler) {
        if (this.conn.getStdinHandler() != this.echoHandler) {
            throw new IllegalStateException();
        }
        if (this.inReadline) {
            throw new IllegalStateException();
        }
        this.inReadline = true;
        this.readline.readline(this.conn, prompt, new RequestHandler(this, lineHandler), new CompletionHandler(completionHandler, this.session));
    }

    @Override
    public Term closeHandler(Handler<Void> handler) {
        if (handler != null) {
            this.conn.setCloseHandler(new CloseHandlerWrapper(handler));
        } else {
            this.conn.setCloseHandler(null);
        }
        return this;
    }

    @Override
    public long lastAccessedTime() {
        return this.conn.lastAccessedTime();
    }

    @Override
    public String type() {
        return this.conn.terminalType();
    }

    @Override
    public int width() {
        return this.conn.size() != null ? this.conn.size().x() : -1;
    }

    @Override
    public int height() {
        return this.conn.size() != null ? this.conn.size().y() : -1;
    }

    void checkPending() {
        if (this.stdinHandler != null && this.readline.hasEvent()) {
            this.stdinHandler.handle(io.termd.core.util.Helper.fromCodePoints(this.readline.nextEvent().buffer().array()));
            this.checkPending();
        }
    }

    @Override
    public TermImpl resizehandler(Handler<Void> handler) {
        if (this.inReadline) {
            throw new IllegalStateException();
        }
        if (handler != null) {
            this.conn.setSizeHandler(new SizeHandlerWrapper(handler));
        } else {
            this.conn.setSizeHandler(null);
        }
        return this;
    }

    @Override
    public Term stdinHandler(Handler<String> handler) {
        if (this.inReadline) {
            throw new IllegalStateException();
        }
        this.stdinHandler = handler;
        if (handler != null) {
            this.conn.setStdinHandler(new StdinHandlerWrapper(handler));
            this.checkPending();
        } else {
            this.conn.setStdinHandler(this.echoHandler);
        }
        return this;
    }

    @Override
    public Term stdoutHandler(Function<String, String> handler) {
        if (this.stdoutHandlerChain == null) {
            this.stdoutHandlerChain = new ArrayList<Function<String, String>>();
        }
        this.stdoutHandlerChain.add(handler);
        return this;
    }

    @Override
    public Term write(String data) {
        if (this.stdoutHandlerChain != null) {
            for (Function<String, String> function : this.stdoutHandlerChain) {
                data = function.apply(data);
            }
        }
        this.conn.write(data);
        return this;
    }

    @Override
    public TermImpl interruptHandler(SignalHandler handler) {
        this.interruptHandler = handler;
        return this;
    }

    @Override
    public TermImpl suspendHandler(SignalHandler handler) {
        this.suspendHandler = handler;
        return this;
    }

    @Override
    public void close() {
        this.conn.close();
        FileUtils.saveCommandHistory(this.readline.getHistory(), new File(Constants.CMD_HISTORY_FILE));
    }

    @Override
    public TermImpl echo(String text) {
        this.echo(io.termd.core.util.Helper.toCodePoints(text));
        return this;
    }

    public void setInReadline(boolean inReadline) {
        this.inReadline = inReadline;
    }

    public Readline getReadline() {
        return this.readline;
    }

    public void handleIntr(Integer key) {
        if (this.interruptHandler == null || !this.interruptHandler.deliver(key)) {
            this.echo(key, 10);
        }
    }

    public void handleEof(Integer key) {
        if (this.stdinHandler != null) {
            this.stdinHandler.handle(io.termd.core.util.Helper.fromCodePoints(new int[]{key}));
        } else {
            this.echo(key);
            this.readline.queueEvent(new int[]{key});
        }
    }

    public void handleSusp(Integer key) {
        if (this.suspendHandler == null || !this.suspendHandler.deliver(key)) {
            this.echo(key, 26);
        }
    }

    public TtyConnection getConn() {
        return this.conn;
    }

    public void echo(int ... codePoints) {
        Consumer<int[]> out = this.conn.stdoutHandler();
        for (int codePoint : codePoints) {
            if (codePoint < 32) {
                if (codePoint == 9) {
                    out.accept(new int[]{9});
                    continue;
                }
                if (codePoint == 8) {
                    out.accept(new int[]{8, 32, 8});
                    continue;
                }
                if (codePoint == 13 || codePoint == 10) {
                    out.accept(new int[]{10});
                    continue;
                }
                out.accept(new int[]{94, codePoint + 64});
                continue;
            }
            if (codePoint == 127) {
                out.accept(new int[]{8, 32, 8});
                continue;
            }
            out.accept(new int[]{codePoint});
        }
    }
}

