package com.ruoyi.system.domain.md.request;

import com.ruoyi.system.domain.md.query.QueryPage;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Setter
@Getter
public class NewMsgQuery extends QueryPage implements Serializable,Cloneable {
    private String inboxid;
    private List<String> inboxids;
    private String outboxid;
    private List<String> outboxids;

    private List<String> userids;

    private String appid;
    private String appname;
    private Byte needreply;

    private Byte msgtype;

    private List<String> toUserids;
    private String toUserid;
    private Byte toUsertype;
    private String toOrgid;
    private String toDeptid;

    private String fromUserid;
    private Byte fromUsertype;
    private String fromOrgid;
    private String fromDeptid;

    private String title;

    private Byte userread;
    private Byte userreply;
    private Byte hasatt;
    private Boolean nullAppid;
    private Boolean nullToOrgid;
    private Byte state;

    private String name;
    private Boolean nullReplypid;
    private String replypid;

    private String starttime;
    private String endtime;

    private String msgcategory;
    private String msglevel;

    private Boolean idOrder;
    private String orders;

    private List<Byte> states;

    private boolean allState = false;

    public boolean getAllState() {
        return allState;
    }

    //自定义查询
    private Map<String,Object> params;

    public void setToUser(NewMsgUser toUser){
        if(toUser != null){
            this.toUserid = toUser.getUserid();
            this.toDeptid = toUser.getDeptid();
        }
    }


    public NewMsgUser getToUser(){
        NewMsgUser user = new NewMsgUser();
        user.setUserid(toUserid);
        user.setDeptid(toDeptid);
        return user;
    }

    public void setFromUser(NewMsgUser fromUser){
        if(fromUser != null){
            this.fromUserid = fromUser.getUserid();
            this.fromDeptid = fromUser.getDeptid();
        }
    }

    public NewMsgUser getFromUser(){
        NewMsgUser user = new NewMsgUser();
        user.setUserid(fromUserid);
        user.setDeptid(fromDeptid);
        return user;
    }

    public NewMsgQuery addParam(String key,Object value){
        if(value != null){
            if(params == null){
                params = new HashMap<>();
            }
            params.put(key,value);
        }
        return this;
    }

    @Override
    public NewMsgQuery clone() {
        try {
            return (NewMsgQuery) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}
