package com.ruoyi.system.domain.md.enums;

import java.util.HashMap;
import java.util.Map;

public enum BooleanType {
    no((byte)0,"否"),yes((byte)1,"是"),del((byte)-2,"删除");

    private byte code;
    private String text;

    BooleanType(byte code, String text) {
        this.code = code;
        this.text = text;
    }

    public static Map<Byte,BooleanType> maps = null;

    static
    {
        maps = new HashMap<>();
        for(BooleanType it : BooleanType.values())
        {
            maps.put(it.getCode(),it);
        }
    }

    public static BooleanType getByCode(byte code)
    {
        return maps.get(code);
    }


    public byte getCode() {
        return code;
    }

    public void setCode(byte code) {
        this.code = code;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public static boolean convert(Byte b){
        return b != null && b.byteValue() == yes.code;
    }

    public static boolean convert(String s){
        return s != null && s.equals(String.valueOf(yes.code));
    }

}
