package com.ruoyi.web.controller.visit;

import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.zqt.ZQTreeNode;
import com.ruoyi.system.domain.visit.VisitFreePlan;
import com.ruoyi.system.domain.visit.VisitFreePlanModel;
import com.ruoyi.system.domain.visit.enums.VisitTypeEnum;
import com.ruoyi.system.domain.visit.ext.VisitFreeInterviewExt;
import com.ruoyi.system.domain.visit.ext.VisitFreePlanModelExt;
import com.ruoyi.system.service.visit.VisitFreeInterviewService;
import com.ruoyi.system.service.visit.VisitFreePlanModelService;
import com.ruoyi.system.service.visit.VisitFreePlanService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

import static com.ruoyi.common.utils.SecurityUtils.getLoginUser;

/**
 * * Author: brenda
 * * 2024/6/21
 **/
@Api(tags = "走访管理 - 更新走访")
@RestController
@RequestMapping("/api/visit/updatePlan")
public class VisitUpdatePlanController {

    @Autowired
    VisitFreePlanModelService visitFreePlanModelService;

    @Autowired
    VisitFreeInterviewService visitFreeInterviewService;

    @Autowired
    VisitFreePlanService visitFreePlanService;

    @RequestMapping(value = "/page", method = RequestMethod.GET)
    public AjaxResult list(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                           @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                           @RequestParam(value = "planAllNum", required = false) Long planAllNum,
                           @RequestParam(value = "startTime", required = false) String startTime,
                           @RequestParam(value = "endTime", required = false) String endTime,
                           @RequestParam(value = "planType", required = false) String planType,
                           @RequestParam(value = "planTitle", required = false) String planTitle) {
        try {
            PageInfo<VisitFreePlanModelExt> pageInfo = visitFreePlanModelService.freePlanModelPage(VisitTypeEnum.UPDATE_VISIT.getCode(), pageNum, pageSize,
                    planAllNum, startTime, endTime, planType, planTitle, null, null);
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    @RequestMapping(value = "/freePlanPage", method = RequestMethod.GET)
    public AjaxResult freePlanPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                   @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                   @RequestParam(value = "wgCode", required = false) String wgCode,
                                   @RequestParam(value = "hasDone", required = false) String hasDone,
                                   @RequestParam(value = "planTitle", required = false) String planTitle) {
        SysUser sysUser = getLoginUser().getUser();
        PageInfo<VisitFreePlan> pageInfo = visitFreePlanModelService.freePlanPage(sysUser, VisitTypeEnum.UPDATE_VISIT.getCode(), pageNum, pageSize,
                wgCode, hasDone, planTitle);
        return AjaxResult.success(pageInfo);
    }

    @RequestMapping(value = "/interviewPage", method = RequestMethod.GET)
    public AjaxResult interviewPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                    @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                    @RequestParam(value = "wgCodes", required = false) List<String> wgCodes,
                                    @RequestParam(value = "wgCode", required = false) String wgCode,
                                    @RequestParam(value = "startTime", required = false) String startTime,
                                    @RequestParam(value = "endTime", required = false) String endTime,
                                    @RequestParam(value = "type", required = false) String type,
                                    @RequestParam(value = "planModelId", required = false) String planModelId) {
        try {
            PageInfo<VisitFreeInterviewExt> pageInfo = visitFreeInterviewService.freeInterviewPage(VisitTypeEnum.FREE_VISIT.getCode(), pageNum, pageSize,
                    wgCodes, startTime, endTime, type, planModelId, wgCode);
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    @PostMapping(value = "/addPlanModel")
    public AjaxResult add(@RequestBody VisitFreePlanModelExt visitFreePlanModelExt) {
        visitFreePlanModelExt.setVisitType(VisitTypeEnum.UPDATE_VISIT.getCode());
        return visitFreePlanModelService.addVisitFreePlanModel(visitFreePlanModelExt);
    }

    @PutMapping(value = "/update")
    public AjaxResult update(@RequestBody VisitFreePlanModelExt visitFreePlanModelExt) {
        visitFreePlanModelExt.setVisitType(VisitTypeEnum.UPDATE_VISIT.getCode());
        return visitFreePlanModelService.updateVisitFreePlanModel(visitFreePlanModelExt);
    }

    @RequestMapping(value = "/delete", method = RequestMethod.DELETE)
    public AjaxResult delete(@RequestBody VisitFreePlanModel planModel) {
        visitFreePlanModelService.delete(planModel.getId());
        return AjaxResult.success("success");
    }

    @RequestMapping(value = "/info", method = RequestMethod.GET)
    public AjaxResult info(@RequestParam(value = "id") String id) {
        VisitFreePlanModelExt visitPlanExt = visitFreePlanModelService.info(id);
        return AjaxResult.success(visitPlanExt);
    }

    @RequestMapping(value = "/Tree", method = RequestMethod.GET)
    public AjaxResult Tree(@RequestParam(value = "id") String id) {
        ZQTreeNode treeNode = visitFreePlanModelService.freePlanTree(id);
        return AjaxResult.success(treeNode);
    }

    @PostMapping(value = "/addInterview")
    public AjaxResult addInterview(@RequestBody VisitFreeInterviewExt visitFreeInterviewExt) {
        visitFreeInterviewExt.setVisitType(VisitTypeEnum.UPDATE_VISIT.getCode());
        return visitFreeInterviewService.addVisitFreeInterview(visitFreeInterviewExt);
    }

    @GetMapping(value = "/interviewCountStatistic")
    public AjaxResult interviewCountStatistic() {
        Map<String, Long> result = visitFreeInterviewService.interviewCountStatistic(VisitTypeEnum.UPDATE_VISIT.getCode());
        return AjaxResult.success(result);
    }

    @RequestMapping(value = "/freePlanInterviewStatistic", method = RequestMethod.GET)
    public AjaxResult freePlanInterviewStatistic(@RequestParam(value = "planModelId") String planModelId,
                                                 @RequestParam(value = "wgCodes", required = false) List<String> wgCodes,
                                                 @RequestParam(value = "wgCode", required = false) String wgCode) {
        Map<String, Long> result = visitFreeInterviewService.freePlanInterviewStatistic(planModelId, wgCodes, wgCode);
        return AjaxResult.success(result);
    }

    @RequestMapping(value = "/modelDoneStatistic", method = RequestMethod.GET)
    public AjaxResult modelDoneStatistic(@RequestParam(value = "planModelId") String planModelId) {
        Map<String, List<VisitFreePlan>> result = visitFreePlanService.modelHasDone(planModelId);
        return AjaxResult.success(result);
    }

    @RequestMapping(value = "/freeInterviewStatistic", method = RequestMethod.GET)
    public AjaxResult freeInterviewStatistic() {
        Map<String, Object> result = visitFreeInterviewService.freeInterviewStatistic(VisitTypeEnum.UPDATE_VISIT.getCode());
        return AjaxResult.success(result);
    }

}
