package com.ruoyi.web.controller.task.request;

import cn.hutool.core.bean.BeanUtil;
import com.google.common.collect.Lists;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.task.dto.TaskCommonParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author vidar
 * date 2024/6/25
 * description
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("日常任务 列表")
public class TaskCommonListRequest extends TaskCommonParams{
    @ApiModelProperty("当前页数")
    private int pageNum = 1;
    @ApiModelProperty("一页几行")
    private int pageSize = 10;
    @ApiModelProperty
    private String roleCode;
    @ApiModelProperty("来源 是否是城运 true:是 false:否")
    private Boolean isTown;

    @ApiModelProperty("未完成")
    private Boolean unfinished = false;
    @ApiModelProperty("已完成")
    private Boolean finished = false;

    @ApiModelProperty("抄送我的")
    private Boolean cswd = false;
    @ApiModelProperty("我执行的")
    private Boolean perform = false;
    @ApiModelProperty("我创建的")
    private Boolean release = false;
    @ApiModelProperty("我审核的")
    private Boolean verification = false;
    @ApiModelProperty("领导交办")
    private Boolean leader = false;
    @ApiModelProperty("转督办")
    private Boolean zdb = false;

    public TaskCommonParams params(){
        TaskCommonParams data = BeanUtil.copyProperties(this, TaskCommonParams.class);
        //未完成
        if (unfinished) {
            data.setFinishedFlag(false);
        }
        //已完成
        if (finished) {
            data.setFinishedFlag(true);
        }
        //抄送我的
        if (cswd) {
            data.setCswdId(this.getLoginUserId());
        }
        //我执行的  需要我处理的，包括指派、任务处理、核查、评价
        if (perform) {
            data.setBeassignedUserId(this.getLoginUserId());
        }
        if (release) {
            data.setReleaseId(this.getLoginUserId());
        }
        if (verification) {//我审核的
            data.setVerificationUserId(this.getLoginUserId());
        }
        if (leader) {//领导交办
            data.setLeaderId(this.getLoginUserId());
        }
        if (zdb) {//转督办
            data.setZdbId(this.getLoginUserId());
            data.setZdbUserName(this.getLoginUserName());
        }
        if (Lists.newArrayList("admin","张茜","郭庆赟","徐文飞","胡逸君").contains(this.getLoginUserName())) {
            data.setRoleLeaveFlag(true);
        }
        if (this.getTkStatus()!=null){
            data.setTkStatuStr(String.valueOf(this.getTkStatus()));
        }
        return data;
    }
}
