package com.ruoyi.system.service.md;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ruoyi.system.domain.md.NewmsgOutbox;
import com.ruoyi.system.domain.md.query.QueryPage;
import com.ruoyi.system.domain.md.request.NewMsgQuery;
import com.ruoyi.system.domain.md.request.NewMsgSendRequest;

import java.util.Map;

/**
 * @author vidar
 * date 2024/6/6
 * description
 **/
public interface NewMsgService {
    /***************** 发送端 *******************/

    /** 发送消息 **/
    String send(NewMsgSendRequest sendRequest);

    /**
     * 查询 发件箱详情
     * @param outboxId
     * @return
     */
    NewmsgOutbox getOutboxDetailNoBody(String outboxId);

    /***************** 接收端 *******************/

    /**
     * 收件箱 分页
     * @param query
     * @param page
     * @return
     */
    IPage<Map<String,Object>> queryUnion(NewMsgQuery query, QueryPage page);

    /** 获取收件箱消息详情 **/
    Map<String,Object> getInboxDetail4Map(String id);

    /** 用户阅读收件箱单条消息 **/
    boolean readInbox(String id);

    /** 用户设置全部已读**/
    boolean readInbox(Byte msgType, NewMsgQuery query);

    /** 获取未读消息数量**/
    int countRead(Byte msgType, NewMsgQuery query, boolean userRead);
}
