package com.ruoyi.web.controller.grid;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridWorkReport;
import com.ruoyi.system.service.grid.GridWorkReportService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author condey
 * @version $$package: com.ruoyi.web.controller.grid, v 0.1 2024/6/24 4:48 PM condey Exp $$
 */
@Api(tags = "数据看板 - 工作简报")
@RestController
@RequestMapping("/api/grid/workReport")
public class GridWorkReportController {

    @Autowired
    private GridWorkReportService gridWorkReportService;

    @GetMapping(value = "/page")
    public AjaxResult page(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                           @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                           @RequestParam(value = "year", required = false) String year,
                           @RequestParam(value = "month", required = false) String month) {
        PageHelper.startPage(pageNum, pageSize);
        PageInfo<GridWorkReport> pageInfo = new PageInfo<>(gridWorkReportService.queryList(year, month));
        return AjaxResult.success(pageInfo);
    }

    /**
     * 重新生成
     *
     * @param report
     * @return
     */
    @PostMapping(value = "/reCreate")
    public AjaxResult reCreate(@RequestBody GridWorkReport report) {
        Long id = gridWorkReportService.createReport(report);
        return AjaxResult.success(id);
    }

    /**
     * 加载详情
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/detail")
    public AjaxResult detail(@RequestParam(value = "id") Long id) {
        return AjaxResult.success(gridWorkReportService.detail(id));
    }
}
