package com.ruoyi.system.service.house.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ruoyi.system.domain.house.HouseResource;
import com.ruoyi.system.domain.house.vo.HouseResourcePage;
import com.ruoyi.system.domain.house.vo.HouseResourcePageQuery;
import com.ruoyi.system.domain.house.vo.HouseResourceSaveDto;
import com.ruoyi.system.mapper.house.HouseResourceAssociationObjectMapper;
import com.ruoyi.system.mapper.house.HouseResourceMapper;
import com.ruoyi.system.service.house.HouseResourceService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;

@Service
public class HouseResourceServiceImpl implements HouseResourceService {

    private final HouseResourceMapper houseResourceMapper;

    private final HouseResourceAssociationObjectMapper houseResourceAssociationObjectMapper;

    public HouseResourceServiceImpl(HouseResourceMapper houseResourceMapper, HouseResourceAssociationObjectMapper houseResourceAssociationObjectMapper) {
        this.houseResourceMapper = houseResourceMapper;
        this.houseResourceAssociationObjectMapper = houseResourceAssociationObjectMapper;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveHouseResource(HouseResourceSaveDto dto) {
        String houseResourceId = UUID.randomUUID().toString().replaceAll("-", "");
        dto.getHouseResource().setId(houseResourceId);
        houseResourceMapper.insertHouseResource(dto.getHouseResource());

        dto.getHouseResourceAssociationObjects().forEach(x -> {
            x.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            x.setHouseResourceId(houseResourceId);
            houseResourceAssociationObjectMapper.insertHouseResourceObjectAssociation(x);
        });
    }

    @Override
    public HouseResource queryHouseResourceById(String id) {
        return houseResourceMapper.selectHouseResourceById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateHouseResource(HouseResource houseResource) {
        houseResourceMapper.updateHouseResource(houseResource);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteHouseResourceById(String id) {
        houseResourceMapper.deleteHouseResourceById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchSaveHouseResources(List<HouseResource> houseResources) {
        houseResourceMapper.batchInsertHouseResources(houseResources);
    }

    @Override
    public IPage<HouseResourcePage> pageHouseResources(HouseResourcePageQuery query) {
        IPage<HouseResourcePage> page = houseResourceMapper.selectPage(new Page<>(query.getPageNum(), query.getPageSize()), query);
        page.getRecords().forEach(x -> {
            x.setHouseResourceUrlList(Arrays.asList(x.getHouseResourceUrl().split(",")));
        });
        return page;
    }
}
