package com.ruoyi.framework.config;


import com.ruoyi.system.domain.video.VideoDeviceChannel;
import com.ruoyi.system.domain.video.ext.ChannelPageRequest;
import com.ruoyi.system.domain.video.ext.ChannelPageResponse;
import com.ruoyi.system.domain.video.ext.HlsUrlRequest;
import com.ruoyi.system.domain.video.ext.HlsUrlResponse;
import com.ruoyi.system.service.video.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class DatabaseInfoUpdate {
    @Autowired
    VideoDeviceChannelService videoDeviceChannelService;
    //数据库更新定时任务
    //更新图片url，当前通道状态

    @Autowired
    private IccCutPicService iccCutPicService;

    @Autowired
    private IccPreviewService iccPreviewService;

    @Autowired
    private IccTokenService iccTokenService;

    @Autowired
    private IccInfoService iccInfoService;

    @Scheduled(fixedRate = 3600000)
    public void func() throws Exception {

        ChannelPageRequest cr = new ChannelPageRequest();
        ChannelPageResponse channelPageResponse = iccInfoService.getChannelPage(cr);
        int totalPages = channelPageResponse.getData().getTotalPage();
        int pageSize = channelPageResponse.getData().getPageSize();
        int totalCount = totalPages * pageSize + 1;
        cr.setPageSize(totalCount);
        channelPageResponse = iccInfoService.getChannelPage(cr);
//        System.out.println(channelPageResponse.getData().getPageData().size());

        List<ChannelPageResponse.PageVO.ChannelInfoVO> data = channelPageResponse.getData().getPageData();
        String token_str = iccTokenService.getToken();
        for(int i=0;i< data.size();i++){
            String code = data.get(i).getChannelCode();
            System.out.println(code);
            String url="",img="";
            HlsUrlRequest hlsUrlRequest = new HlsUrlRequest();
            hlsUrlRequest.setData(new HlsUrlRequest.Data());
            hlsUrlRequest.getData().setChannelId(code);
            hlsUrlRequest.getData().setType("hls");
            hlsUrlRequest.getData().setStreamType("1");
            HlsUrlResponse hlsUrlResponse = iccPreviewService.getHlsUrl(hlsUrlRequest);
            hlsUrlRequest.getData().setStreamType("2");
            url = hlsUrlResponse.getData().getUrl() + "?token=" + token_str;
            try{
                img = iccCutPicService.remoteCapture(2L,code);
            }catch (Exception e){
                e.printStackTrace();
            }

            ChannelPageResponse.PageVO.ChannelInfoVO channelInfoVO = data.get(i);
            VideoDeviceChannel videoDeviceChannel = new VideoDeviceChannel();
            videoDeviceChannel.setChannelCode(channelInfoVO.getChannelCode());
            videoDeviceChannel.setStatus(String.valueOf(channelInfoVO.getIsOnline()));
            videoDeviceChannel.setUrl(url);
            videoDeviceChannel.setImg(img);
            System.out.println(videoDeviceChannel);

            videoDeviceChannelService.UpdateDatabaseInfo(videoDeviceChannel);
        }
    }
}
