/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.client;

import com.taobao.arthas.client.IOUtil;
import com.taobao.arthas.common.OSUtils;
import com.taobao.arthas.common.UsageRender;
import com.taobao.middleware.cli.CLI;
import com.taobao.middleware.cli.CommandLine;
import com.taobao.middleware.cli.UsageMessageFormatter;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.CLIConfigurator;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import jline.Terminal;
import jline.UnixTerminal;
import jline.console.ConsoleReader;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.WindowSizeOptionHandler;

@Name(value="arthas-client")
@Summary(value="Arthas Telnet Client")
@Description(value="EXAMPLES:\n  java -jar arthas-client.jar 127.0.0.1 3658\n  java -jar arthas-client.jar -c 'dashboard -n 1' \n  java -jar arthas-client.jar -f batch.as 127.0.0.1\n")
public class TelnetConsole {
    private static final String PROMPT = "[arthas@";
    private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private static final byte CTRL_C = 3;
    public static final int STATUS_OK = 0;
    public static final int STATUS_ERROR = 1;
    public static final int STATUS_EXEC_TIMEOUT = 100;
    public static final int STATUS_EXEC_ERROR = 101;
    private boolean help = false;
    private String targetIp = "127.0.0.1";
    private int port = 3658;
    private String command;
    private String batchFile;
    private int executionTimeout = -1;
    private Integer width = null;
    private Integer height = null;

    @Argument(argName="target-ip", index=0, required=false)
    @Description(value="Target ip")
    public void setTargetIp(String targetIp) {
        this.targetIp = targetIp;
    }

    @Argument(argName="port", index=1, required=false)
    @Description(value="The remote server port")
    public void setPort(int port) {
        this.port = port;
    }

    @Option(longName="help", flag=true)
    @Description(value="Print usage")
    public void setHelp(boolean help) {
        this.help = help;
    }

    @Option(shortName="c", longName="command")
    @Description(value="Command to execute, multiple commands separated by ;")
    public void setCommand(String command) {
        this.command = command;
    }

    @Option(shortName="f", longName="batch-file")
    @Description(value="The batch file to execute")
    public void setBatchFile(String batchFile) {
        this.batchFile = batchFile;
    }

    @Option(shortName="t", longName="execution-timeout")
    @Description(value="The timeout (ms) of execute commands or batch file ")
    public void setExecutionTimeout(int executionTimeout) {
        this.executionTimeout = executionTimeout;
    }

    @Option(shortName="w", longName="width")
    @Description(value="The terminal width")
    public void setWidth(int width) {
        this.width = width;
    }

    @Option(shortName="h", longName="height")
    @Description(value="The terminal height")
    public void setheight(int height) {
        this.height = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readLines(File batchFile) {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(batchFile));
            String line = br.readLine();
            while (line != null) {
                list.add(line);
                line = br.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        try {
            int status = TelnetConsole.process(args, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
            System.exit(status);
        }
        catch (Throwable e) {
            e.printStackTrace();
            CLI cli = CLIConfigurator.define(TelnetConsole.class);
            System.out.println(TelnetConsole.usage(cli));
            System.exit(1);
        }
    }

    public static int process(String[] args) throws IOException, InterruptedException {
        return TelnetConsole.process(args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int process(String[] args, ActionListener eotEventCallback) throws IOException {
        if (OSUtils.isCygwinOrMinGW()) {
            System.setProperty("jline.terminal", System.getProperty("jline.terminal", "jline.UnixTerminal"));
        }
        TelnetConsole telnetConsole = new TelnetConsole();
        CLI cli = CLIConfigurator.define(TelnetConsole.class);
        CommandLine commandLine = cli.parse(Arrays.asList(args));
        CLIConfigurator.inject(commandLine, telnetConsole);
        if (telnetConsole.isHelp()) {
            System.out.println(TelnetConsole.usage(cli));
            return 1;
        }
        ArrayList<String> cmds = new ArrayList<String>();
        if (telnetConsole.getCommand() != null) {
            for (String c : telnetConsole.getCommand().split(";")) {
                cmds.add(c.trim());
            }
        } else if (telnetConsole.getBatchFile() != null) {
            File file = new File(telnetConsole.getBatchFile());
            if (!file.exists()) {
                throw new IllegalArgumentException("batch file do not exist: " + telnetConsole.getBatchFile());
            }
            cmds.addAll(TelnetConsole.readLines(file));
        }
        final ConsoleReader consoleReader = new ConsoleReader(System.in, System.out);
        consoleReader.setHandleUserInterrupt(true);
        Terminal terminal = consoleReader.getTerminal();
        terminal.disableInterruptCharacter();
        if (terminal instanceof UnixTerminal) {
            ((UnixTerminal)terminal).disableLitteralNextCharacter();
        }
        try {
            int width = 80;
            int height = 24;
            if (!cmds.isEmpty()) {
                if (telnetConsole.getWidth() != null) {
                    width = telnetConsole.getWidth();
                }
                if (telnetConsole.getheight() != null) {
                    height = telnetConsole.getheight();
                }
            } else {
                if (telnetConsole.getWidth() != null) {
                    width = telnetConsole.getWidth();
                } else {
                    width = terminal.getWidth();
                    if (OSUtils.isWindows()) {
                        --width;
                    }
                }
                height = telnetConsole.getheight() != null ? telnetConsole.getheight().intValue() : terminal.getHeight();
            }
            final TelnetClient telnet = new TelnetClient();
            telnet.setConnectTimeout(5000);
            WindowSizeOptionHandler sizeOpt = new WindowSizeOptionHandler(width, height, true, true, false, false);
            try {
                telnet.addOptionHandler(sizeOpt);
            }
            catch (InvalidTelnetOptionException invalidTelnetOptionException) {
                // empty catch block
            }
            consoleReader.getKeys().bind(Character.toString('\u0003'), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        consoleReader.getCursorBuffer().clear();
                        telnet.getOutputStream().write(3);
                        telnet.getOutputStream().flush();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            });
            consoleReader.getKeys().bind(Character.toString('\u0004'), eotEventCallback);
            try {
                telnet.connect(telnetConsole.getTargetIp(), telnetConsole.getPort());
            }
            catch (IOException e) {
                System.out.println("Connect to telnet server error: " + telnetConsole.getTargetIp() + " " + telnetConsole.getPort());
                throw e;
            }
            if (!cmds.isEmpty()) {
                int e = TelnetConsole.batchModeRun(telnet, cmds, telnetConsole.getExecutionTimeout());
                try {
                    telnet.disconnect();
                    return e;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return e;
                catch (Throwable e2) {
                    System.out.println("Execute commands error: " + e2.getMessage());
                    e2.printStackTrace();
                    int e3 = 101;
                    try {
                        terminal.restore();
                        return e3;
                    }
                    catch (Throwable e4) {
                        System.out.println("Restore terminal settings failure: " + e4.getMessage());
                        e4.printStackTrace();
                    }
                    return e3;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            IOUtil.readWrite(telnet.getInputStream(), telnet.getOutputStream(), consoleReader.getInput(), consoleReader.getOutput());
            int n = 0;
            return n;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
                {
                    finally {
                        try {
                            telnet.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        finally {
            try {
                terminal.restore();
            }
            catch (Throwable e3) {
                System.out.println("Restore terminal settings failure: " + e3.getMessage());
                e3.printStackTrace();
            }
        }
    }

    private static int batchModeRun(TelnetClient telnet, List<String> commands, int executionTimeout) throws IOException, InterruptedException {
        if (commands.size() == 0) {
            return 0;
        }
        long startTime = System.currentTimeMillis();
        final InputStream inputStream = telnet.getInputStream();
        OutputStream outputStream = telnet.getOutputStream();
        final LinkedBlockingQueue receviedPromptQueue = new LinkedBlockingQueue(1);
        Thread printResultThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    StringBuilder line = new StringBuilder();
                    BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    int b = -1;
                    while ((b = in.read()) != -1) {
                        line.appendCodePoint(b);
                        int index = line.indexOf(TelnetConsole.PROMPT);
                        if (index > 0) {
                            line.delete(0, index + TelnetConsole.PROMPT.length());
                            receviedPromptQueue.put("");
                        }
                        System.out.print(Character.toChars(b));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        printResultThread.start();
        for (String command : commands) {
            if (command.trim().isEmpty()) continue;
            while (receviedPromptQueue.poll(100L, TimeUnit.MILLISECONDS) == null) {
                long now;
                if (executionTimeout <= 0 || (now = System.currentTimeMillis()) - startTime <= (long)executionTimeout) continue;
                return 100;
            }
            outputStream.write((command + " | plaintext\n").getBytes());
            outputStream.flush();
        }
        receviedPromptQueue.take();
        outputStream.write("quit\n".getBytes());
        outputStream.flush();
        System.out.println();
        return 0;
    }

    private static String usage(CLI cli) {
        StringBuilder usageStringBuilder = new StringBuilder();
        UsageMessageFormatter usageMessageFormatter = new UsageMessageFormatter();
        usageMessageFormatter.setOptionComparator(null);
        cli.usage(usageStringBuilder, usageMessageFormatter);
        return UsageRender.render(usageStringBuilder.toString());
    }

    public String getTargetIp() {
        return this.targetIp;
    }

    public int getPort() {
        return this.port;
    }

    public String getCommand() {
        return this.command;
    }

    public String getBatchFile() {
        return this.batchFile;
    }

    public int getExecutionTimeout() {
        return this.executionTimeout;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getheight() {
        return this.height;
    }

    public boolean isHelp() {
        return this.help;
    }
}

