package com.ruoyi.system.service.grid;

import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridCompanyLand;
import com.ruoyi.system.domain.grid.GridCompanyLandExample;
import com.ruoyi.system.domain.grid.ext.GridCompanyLandExt;
import com.ruoyi.system.domain.grid.vo.GridEconomyPerMuItem;
import com.ruoyi.system.service.BaseService;

import java.util.List;
import java.util.Map;

/**
 * @author yaoqiang
 * @date 2023-04-20 16:09
 * @desc GridCompanyLandService接口
 */
public interface GridCompanyLandService extends BaseService<GridCompanyLand, GridCompanyLandExample> {

    PageInfo<GridCompanyLandExt> page(Integer pageNo, Integer pageSize, String companyId, String landId, String landPurpose);

    AjaxResult saveOrUpdate(GridCompanyLand wsCompanyLand);

    void delete(String id);

    GridCompanyLandExt detail(String id);

    Map<String, String> infoStatistic(String year);

    Map<String, String> leaseStatistic();

    List<GridEconomyPerMuItem> permuSortList(String year);

}
