package com.ruoyi.system.service.other.impl;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.zqt.ZQTPageModel;
import com.ruoyi.system.domain.other.BsCommon;
import com.ruoyi.system.domain.other.BsCommonExample;
import com.ruoyi.system.domain.other.vo.BsCommonVO;
import com.ruoyi.system.service.other.BsCommonService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: hxc
 * @Date: 2019/6/18 0018 09:23
 * @Description: 数据字典
 */
@Component
public class FlpzService {

    @Autowired
    private BsCommonService bsCommonService;

    public void delete(BsCommon body, AjaxResult result) {

        // 如果该网格下有子网格，则无法删除
        BsCommonExample bsWgxxbExample = new BsCommonExample();
        bsWgxxbExample.createCriteria().andIsValidEqualTo("1").andParentIdEqualTo(body.getId());
        int count = bsCommonService.countByExample(bsWgxxbExample);
        if (count > 0) {
            result.put("status",600);
            result.put("msg","该数据下存在子数据，请先删除子数据");
            result.put("data","该数据下存在子数据，请先删除子数据");
            return;
        }

        // 防止数据残留
        int ret = bsCommonService.deleteByStringPrimaryKey(body.getId());
        if (ret > 0) {
            result.put("status",200);
            result.put("msg","success");
            result.put("data","1");
        } else {
            result.put("status",500);
            result.put("msg","删除失败");
            result.put("data","删除失败");
        }

        return;
    }



    public void getRoles(BsCommonVO bsCommonVO, AjaxResult result) {
        Integer pageNum = bsCommonVO.getPageNum();
        Integer pageSize = bsCommonVO.getPageSize();
        if (null == pageNum || pageNum <= 0) {
            pageNum = 1;
        }
        if (null == pageSize || pageSize <= 0) {
            pageSize = 10;
        }

        ZQTPageModel<BsCommon> appPageModel = new ZQTPageModel<>();
        appPageModel.setRecordCount(0);
        appPageModel.setPageCount(0);
        appPageModel.setCurPage(pageNum);
        appPageModel.setItemList(new ArrayList<>());

        BsCommonExample example = new BsCommonExample();
        BsCommonExample.Criteria criteria = example.createCriteria();

        if(StringUtils.isNotEmpty(bsCommonVO.getParentId())){
            criteria.andParentIdEqualTo(bsCommonVO.getParentId());
        }
        example.setOrderByClause("sort asc");
        int count = bsCommonService.countByExample(example);
        if (count <= 0) {
            result.put("status",200);
            result.put("msg","success");
            result.put("data",appPageModel);
            return;
        }
        List<BsCommon> roles = bsCommonService.selectByExampleForStartPage(example, pageNum, pageSize);
        if (null == roles || roles.isEmpty()) {
            result.put("status",200);
            result.put("msg","success");
            result.put("data",appPageModel);
            return;
        }
        appPageModel.setCurPage(pageNum);
        appPageModel.setRecordCount(count);
        appPageModel.setPageCount((long) Math.ceil(1.0 * count / pageSize));
        appPageModel.setItemList(roles);
        result.put("status",200);
        result.put("msg","success");
        result.put("data",appPageModel);
        return;
    }

    public void getTreeNode(BsCommonVO bsCommonVO, AjaxResult result) {
        BsCommonExample bsCommonExample = new BsCommonExample();
        bsCommonExample.createCriteria().andIsValidEqualTo("1");
        bsCommonExample.setOrderByClause("sort asc");
        List<BsCommon> bsCommons = bsCommonService.selectByExample(bsCommonExample);
        List<Map<String, Object>> jsTreeModels = convertFrBomsCommon(bsCommons);
        result.put("status",200);
        result.put("msg","success");
        result.put("data",jsTreeModels);
        return;
    }

    private List<Map<String, Object>> convertFrBomsCommon(List<BsCommon> bsCommons) {
        List<Map<String, Object>> models = new ArrayList<>();

        if (!CollectionUtils.isEmpty(bsCommons)) {
            for (BsCommon bsCommon : bsCommons) {
                if (StringUtils.isEmpty(bsCommon.getParentId())) {
                    Map<String, Object> model = new HashMap<>();
                    model.put("id", bsCommon.getId());
                    model.put("code", bsCommon.getCode());
                    model.put("name", bsCommon.getName());
                    model.put("description", bsCommon.getDescription());
                    model.put("parentId", bsCommon.getParentId());
                    model.put("isValid", bsCommon.getIsValid());
                    model.put("sort", bsCommon.getSort());
                    List<Map<String, Object>> childrenDocTypes = convertFromWgCodeByParent(bsCommons,bsCommon.getId());
                    model.put("child", childrenDocTypes);
                    models.add(model);
                }
            }
        }
        return models;
    }


    private List<Map<String, Object>> convertFromWgCodeByParent(List<BsCommon> bsCommons, String parentId) {
        List<Map<String, Object>> models = new ArrayList<>();

        for (BsCommon bsCommon : bsCommons) {
            if (StringUtils.isNotEmpty(bsCommon.getParentId()) && bsCommon.getParentId().equals(parentId)) {
                Map<String, Object> model = new HashMap<>();
                model.put("id", bsCommon.getId());
                model.put("code", bsCommon.getCode());
                model.put("name", bsCommon.getName());
                model.put("description", bsCommon.getDescription());
                model.put("parentId", bsCommon.getParentId());
                model.put("isValid", bsCommon.getIsValid());
                model.put("sort", bsCommon.getSort());
                List<Map<String, Object>> childrenDocTypes = convertFromWgCodeByParent(bsCommons, bsCommon.getId());
                model.put("child", childrenDocTypes);
                models.add(model);
            }
        }
        return models;
    }
    private boolean itemIsUUID(String item) {
        if (StringUtils.isEmpty(item)) {
            return false;
        }
        return item.matches("(\\w{8}(-\\w{4}){3}-\\w{12}?)");
    }


    public List<BsCommon> getWgNameList(Integer pageNum,Integer pageSize,String name, AjaxResult result) {
        if (null == pageNum || pageNum <= 0) {
            pageNum = 1;
        }
        if (null == pageSize || pageSize <= 0) {
            pageSize = 10;
        }

        ZQTPageModel<BsCommon> appPageModel = new ZQTPageModel<>();
        appPageModel.setRecordCount(0);
        appPageModel.setPageCount(0);
        appPageModel.setCurPage(pageNum);
        appPageModel.setItemList(new ArrayList<>());

        BsCommonExample example = new BsCommonExample();
        BsCommonExample.Criteria criteria = example.createCriteria();
        criteria.andIsValidEqualTo("1");
        criteria.andNameEqualTo(name);

        BsCommon roles = bsCommonService.selectFirstByExample(example);

        if(roles != null){
            BsCommonExample example1 = new BsCommonExample();
            BsCommonExample.Criteria criteria1 = example1.createCriteria();
            criteria1.andParentIdEqualTo(roles.getId());
            int count = bsCommonService.countByExample(example1);
            example1.setOrderByClause("sort asc");
            List<BsCommon> list= bsCommonService.selectByExampleForStartPage(example1, pageNum, pageSize);
            if (count <= 0) {
                result.put("status",200);
                result.put("msg","success");
                result.put("data",appPageModel);
                return null;
            }
            appPageModel.setCurPage(pageNum);
            appPageModel.setRecordCount(count);
            appPageModel.setPageCount((long) Math.ceil(1.0 * count / pageSize));
            appPageModel.setItemList(list);
        }

        result.put("status",200);
        result.put("msg","success");
        result.put("data",appPageModel);
        return null;
    }
}
