package com.ruoyi.system.service.other.impl;

import com.ruoyi.system.domain.other.BsCommon;
import com.ruoyi.system.domain.other.BsCommonExample;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.other.BsCommonMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.other.BsCommonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc BsCommonService实现
 */
@Service
@MyBaseService
public class BsCommonServiceImpl extends BaseServiceImpl<BsCommonMapper, BsCommon, BsCommonExample> implements BsCommonService {

    private static final Logger LOGGER = LoggerFactory.getLogger(BsCommonServiceImpl.class);

    @Autowired
    private BsCommonMapper bsCommonMapper;

    @Override
    public List<BsCommon> getWgdxList(String code) {
        return bsCommonMapper.getWgdxList(code);
    }

    @Override
    public String getName(String code) {
        BsCommonExample ex = new BsCommonExample();
        BsCommonExample.Criteria ca = ex.createCriteria();
        ca.andCodeEqualTo(code);
        ca.andIsValidEqualTo("1");
        BsCommon bsCommon = selectFirstByExample(ex);
        if (bsCommon != null) {
            return bsCommon.getName();
        } else {
            return null;
        }
    }

    @Override
    public String getCode(String name) {
        BsCommonExample ex = new BsCommonExample();
        BsCommonExample.Criteria ca = ex.createCriteria();
        ca.andNameEqualTo(name);
        ca.andIsValidEqualTo("1");
        BsCommon bsCommon = selectFirstByExample(ex);
        if (bsCommon != null) {
            return bsCommon.getCode();
        } else {
            return null;
        }
    }

    @Override
    public List<BsCommon> getBsCommonMap() {
        BsCommonExample ex = new BsCommonExample();
        BsCommonExample.Criteria ca = ex.createCriteria();
        ca.andIsValidEqualTo("1");
        return this.selectByExample(ex);
    }

    @Override
    public Map<String, String> getMapByCodes(List<String> codes) {
        BsCommonExample ex = new BsCommonExample();
        BsCommonExample.Criteria ca = ex.createCriteria();
        ca.andIsValidEqualTo("1");
        ca.andCodeIn(codes);
        List<BsCommon> commonList = bsCommonMapper.selectByExample(ex);
        return commonList.stream().collect(Collectors.toMap(BsCommon::getCode, BsCommon::getName));
    }
}
