package com.ruoyi.system.service.visit;

import com.github.pagehelper.PageInfo;
import com.ruoyi.common.zqt.ZQTreeNode;
import com.ruoyi.system.domain.grid.vo.GridWgBean;
import com.ruoyi.system.domain.visit.VisitPlan;
import com.ruoyi.system.domain.visit.VisitPlanExample;
import com.ruoyi.system.domain.visit.ext.VisitPlanExt;
import com.ruoyi.system.domain.visit.ext.VisitPlanTaskExt;
import com.ruoyi.system.domain.visit.vo.VisitPlanRate;
import com.ruoyi.system.service.BaseService;

import java.util.List;
import java.util.Map;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc VisitPlanService接口
 */
public interface VisitPlanService extends BaseService<VisitPlan, VisitPlanExample> {

    PageInfo<VisitPlanExt> selectByPage(int pageNum, int pageSize, String planTitle, String planType, String planTime, String planObjType, String planFl);

    void save(VisitPlanExt wszfPlanExt);

    void update(VisitPlanExt wszfPlanExt);

    /**
     * 填写完表单，更新记录id
     * @param planTaskId
     * @param recordId
     */
    void updateTaskRecordId(String planTaskId, String recordId);

    void delete(String id);

    VisitPlanExt info(String id);

    PageInfo<VisitPlanTaskExt> planTaskPage(int pageNum, int pageSize, String planId, String planTaskStatus, String objWgCode, String startTime, String endTime, String objType, String objName);

    ZQTreeNode getPlanWgTree(String planId);

    Map<String, String> infoTj(String wgCode, String planId);

    Map<String, String> aqzfPcTj();

    /**
     * app端安全走访统计（企业+九小场所巡检）
     * @param startDate
     * @param endDate
     * @return
     */
    Map<String, Integer> appAqzfTj(String startDate, String endDate, String objType, String wgCode);

    Map<String, String> rhzfPcTj(String wgCode);

    List<Map<String, Object>> nearSevenDayTaskNum(String wgCode, String startTime);

    List<GridWgBean> selectAqzfTj(String wgCode, String time);

    VisitPlanTaskExt planTaskInfo(String id);

    void updatePlanTask(VisitPlanTaskExt wszfPlanTask);

    Map<String, Object> countPlanTaskByUserId(String userId);

    PageInfo<VisitPlanTaskExt> planTaskPageApp(int pageNum, int pageSize, String userId, String planTaskStatus, String objName, String objType, String planFl);

    /**
     * 统计进六周的走访数量和走访率
     *
     * @param wszfPlanRate
     * @return
     */
    List<VisitPlanRate> getPlatRate(VisitPlanRate wszfPlanRate);

    PageInfo<Map<String, Object>> getPatrolRecordPage(String objId, int pageNum, int pageSize);

    PageInfo<Map<String, Object>> getYhzgPage(String objId, int pageNum, int pageSize);

    PageInfo<VisitPlanTaskExt> planTaskForPage(int pageNum, int pageSize, String wgCode, String planFl);

    void updateByPlanTask(String userId, String planTaskStatus, String planTaskFeedback, String objId, String updateTime, String otherappAttachments, String qddkdz);

    /**
     * 30天内走访数量
     * @return
     */
    long latestVisitCount(String objType, String objId);
}
