package com.ruoyi.system.service.stamp;

import com.ruoyi.system.domain.stamp.CarDinnerExamineUser;
import com.ruoyi.system.domain.stamp.request.CarDinnerExamineRequest;
import com.ruoyi.system.domain.stamp.vo.ExamineSaveOtherBusInfo;
import com.ruoyi.system.domain.stamp.vo.ExamineUserExt;

import java.util.List;

/**
 * * Author: brenda
 * * 2025/2/8
 **/
public interface CarDinnerExamineUserService {

    /**
     * 审批，返回是否全部审批完成
     * @param request
     * @return
     */
    boolean apply(CarDinnerExamineRequest request);

    /**
     * 保存审批信息
     * @param examineUsers
     * @param busInfo
     */
    void saveExamineInfo(List<CarDinnerExamineUser> examineUsers, ExamineSaveOtherBusInfo busInfo);

    /**
     * 已审批的
     * @param busId
     * @param type
     * @return
     */
    List<ExamineUserExt> hasExamined(String busId, String type);

    /**
     * 完整的审批列表
     * @param busId
     * @param type
     * @return
     */
    List<ExamineUserExt> allExamineList(String busId, String type);

    /**
     * 是否能审批
     * @param busId
     * @param userId
     * @param type
     * @return
     */
    boolean canApply(String busId, String userId, String type);

}
