package com.ruoyi.system.domain.grid;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
public class GridCompanyEconomyInfo implements Serializable {
    private String id;

    /**
     * 企业id
     *
     * @mbg.generated
     */
    private String companyId;

    /**
     * 年度销售
     *
     * @mbg.generated
     */
    private BigDecimal sale;

    /**
     * 年度税收
     *
     * @mbg.generated
     */
    private BigDecimal tax;

    /**
     * 亩均经济，单位W
     *
     * @mbg.generated
     */
    private BigDecimal perMu;

    /**
     * 年度
     *
     * @mbg.generated
     */
    private String year;

    /**
     * 1:有效 0：无效
     *
     * @mbg.generated
     */
    private String isValid;

    /**
     * 创建时间
     *
     * @mbg.generated
     */
    private String createTime;


    private String companyName;

    private List<String> sales;

    private List<String> taxes;

    private String yearSales;

    private String yearTaxes;

    private static final long serialVersionUID = 1L;

//    public String getId() {
//        return id;
//    }
//
//    public void setId(String id) {
//        this.id = id;
//    }
//
//    public String getCompanyId() {
//        return companyId;
//    }
//
//    public void setCompanyId(String companyId) {
//        this.companyId = companyId;
//    }
//
//    public BigDecimal getSale() {
//        return sale;
//    }
//
//    public void setSale(BigDecimal sale) {
//        this.sale = sale;
//    }
//
//    public BigDecimal getTax() {
//        return tax;
//    }
//
//    public void setTax(BigDecimal tax) {
//        this.tax = tax;
//    }
//
//    public BigDecimal getPerMu() {
//        return perMu;
//    }
//
//    public void setPerMu(BigDecimal perMu) {
//        this.perMu = perMu;
//    }
//
//    public String getYear() {
//        return year;
//    }
//
//    public void setYear(String year) {
//        this.year = year;
//    }
//
//    public String getIsValid() {
//        return isValid;
//    }
//
//    public void setIsValid(String isValid) {
//        this.isValid = isValid;
//    }
//
//    public String getCreateTime() {
//        return createTime;
//    }
//
//    public void setCreateTime(String createTime) {
//        this.createTime = createTime;
//    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", companyId=").append(companyId);
        sb.append(", sale=").append(sale);
        sb.append(", tax=").append(tax);
        sb.append(", perMu=").append(perMu);
        sb.append(", year=").append(year);
        sb.append(", isValid=").append(isValid);
        sb.append(", createTime=").append(createTime);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        GridCompanyEconomyInfo other = (GridCompanyEconomyInfo) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getCompanyId() == null ? other.getCompanyId() == null : this.getCompanyId().equals(other.getCompanyId()))
            && (this.getSale() == null ? other.getSale() == null : this.getSale().equals(other.getSale()))
            && (this.getTax() == null ? other.getTax() == null : this.getTax().equals(other.getTax()))
            && (this.getPerMu() == null ? other.getPerMu() == null : this.getPerMu().equals(other.getPerMu()))
            && (this.getYear() == null ? other.getYear() == null : this.getYear().equals(other.getYear()))
            && (this.getIsValid() == null ? other.getIsValid() == null : this.getIsValid().equals(other.getIsValid()))
            && (this.getCreateTime() == null ? other.getCreateTime() == null : this.getCreateTime().equals(other.getCreateTime()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getCompanyId() == null) ? 0 : getCompanyId().hashCode());
        result = prime * result + ((getSale() == null) ? 0 : getSale().hashCode());
        result = prime * result + ((getTax() == null) ? 0 : getTax().hashCode());
        result = prime * result + ((getPerMu() == null) ? 0 : getPerMu().hashCode());
        result = prime * result + ((getYear() == null) ? 0 : getYear().hashCode());
        result = prime * result + ((getIsValid() == null) ? 0 : getIsValid().hashCode());
        result = prime * result + ((getCreateTime() == null) ? 0 : getCreateTime().hashCode());
        return result;
    }
}