package com.ruoyi.system.service.md.impl;

import com.alibaba.fastjson2.JSONObject;
import com.ruoyi.system.domain.md.NewmsgOutbox;
import com.ruoyi.system.domain.md.NewmsgOutboxExample;
import com.ruoyi.system.domain.md.enums.OutboxState;
import com.ruoyi.system.domain.md.request.NewMsgSendData;
import com.ruoyi.system.domain.md.request.NewMsgUser;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.md.NewmsgOutboxMapper;
import com.ruoyi.system.mapper.md.ext.ExtOutboxMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.md.NewmsgOutboxService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.UUID;

/**
 * @author vidar
 * date 2024/6/6
 * description
 **/
@Service
@MyBaseService
public class NewmsgOutboxServiceImpl extends BaseServiceImpl<NewmsgOutboxMapper, NewmsgOutbox, NewmsgOutboxExample> implements NewmsgOutboxService {
    @Resource
    private ExtOutboxMapper extOutboxMapper;

    @Override
    @Transactional
    public String saveDraft(NewMsgSendData sendData, NewMsgUser from) {
        if(sendData == null){
            return null;
        }
        NewmsgOutbox outbox = new NewmsgOutbox();
        BeanUtils.copyProperties(sendData,outbox);
        if(!CollectionUtils.isEmpty(sendData.getExtMap())){
            outbox.setExt(JSONObject.toJSONString(sendData.getExtMap()));
        }
        if(!CollectionUtils.isEmpty(sendData.getParams())){
            outbox.setParams(JSONObject.toJSONString(sendData.getParams()));
        }
        if(from != null){
            outbox.setUserid(from.getUserid());
            outbox.setDeptid(from.getDeptid());
        }
        int count;
        if(StringUtils.isNotBlank(sendData.getOutboxid())){
            outbox.setId(sendData.getOutboxid());
            outbox.setUtime(System.currentTimeMillis());
            outbox.setState(OutboxState.draft.getCode());
            count = this.updateByPrimaryKeySelective(outbox);
        }else{
            outbox.setId(UUID.randomUUID().toString());
            outbox.setCtime(System.currentTimeMillis());
            outbox.setUtime(System.currentTimeMillis());
            outbox.setState(OutboxState.draft.getCode());
            count =  this.insertSelective(outbox);
        }
        return count > 0 ? outbox.getId() : "";
    }

    @Override
    public void updateOutboxState(String outboxId, OutboxState state) {
        if(StringUtils.isBlank(outboxId)){
            return;
        }
        NewmsgOutbox outbox = new NewmsgOutbox();
        outbox.setId(outboxId);
        outbox.setUtime(System.currentTimeMillis());
        outbox.setState(state.getCode());
        this.updateByPrimaryKeySelective(outbox);
    }

    @Override
    public NewmsgOutbox getOutboxDetailNoBody(String id) {
        if(StringUtils.isBlank(id)){
            return null;
        }
        NewmsgOutboxExample example1 = new NewmsgOutboxExample();
        example1.createCriteria().andIdEqualTo(id);
        List<NewmsgOutbox> list = extOutboxMapper.selectByExampleWithBLOBsNoBody(example1);
        return CollectionUtils.isEmpty(list) ? null : list.get(0);
    }
}
